/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeType;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.molgenis.vcf.decisiontree.UnexpectedEnumException;
import org.molgenis.vcf.decisiontree.filter.Allele;
import org.molgenis.vcf.decisiontree.filter.FlagListException;
import org.molgenis.vcf.decisiontree.filter.UnknownFieldException;
import org.molgenis.vcf.decisiontree.filter.UnsupportedFormatFieldException;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.GenotypeFieldType;
import org.molgenis.vcf.decisiontree.filter.model.NestedField;
import org.molgenis.vcf.decisiontree.filter.model.SampleContext;
import org.molgenis.vcf.decisiontree.filter.model.SampleFieldType;
import org.molgenis.vcf.decisiontree.filter.model.ValueCount;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.molgenis.vcf.decisiontree.utils.VcfUtils;
import org.springframework.lang.Nullable;

public class VcfRecord {
    private static final List<String> PASS_FILTER = List.of("PASS");
    private VariantContext variantContext;

    public VcfRecord(VariantContext variantContext) {
        this.variantContext = Objects.requireNonNull(variantContext);
    }

    public VariantContext getVariantContext() {
        return this.variantContext;
    }

    public int getNrAltAlleles() {
        return this.variantContext.getNAlleles() - 1;
    }

    public Allele getAltAllele(int altAlleleIndex) {
        String bases = this.variantContext.getAlternateAllele(altAlleleIndex).getBaseString();
        int alleleIndex = altAlleleIndex + 1;
        return new Allele(bases, alleleIndex);
    }

    public Object getValue(Field field, Allele allele) {
        return this.getValue(field, allele, null);
    }

    public Object getValue(Field field, Allele allele, @Nullable SampleContext sampleContext) {
        FieldType fieldType = field.getFieldType();
        return switch (fieldType) {
            case FieldType.COMMON -> this.getCommonValue(field, allele);
            case FieldType.INFO -> this.getInfoValue(field, allele);
            case FieldType.INFO_VEP -> this.getNestedVepValue(field);
            case FieldType.GENOTYPE -> sampleContext != null ? this.getNestedGTValue((NestedField)field, sampleContext) : null;
            case FieldType.FORMAT -> {
                if (sampleContext == null) {
                    throw new UnsupportedOperationException("Cannot filter on FORMAT fields when running in variant filter mode.");
                }
                yield this.getFormatField(field, sampleContext);
            }
            case FieldType.SAMPLE -> sampleContext != null ? this.getSampleValue(field, sampleContext) : null;
            default -> throw new UnexpectedEnumException(fieldType);
        };
    }

    private Object getSampleValue(Field field, SampleContext sampleContext) {
        SampleFieldType sampleField = SampleFieldType.valueOf(field.getId().toUpperCase());
        return switch (sampleField) {
            case SampleFieldType.ID -> sampleContext.getId();
            case SampleFieldType.AFFECTED_STATUS -> sampleContext.getAffectedStatus().toString();
            case SampleFieldType.SEX -> sampleContext.getSex().toString();
            case SampleFieldType.FATHER_ID -> sampleContext.getFatherId();
            case SampleFieldType.MOTHER_ID -> sampleContext.getMotherId();
            case SampleFieldType.FAMILY_ID -> sampleContext.getFamilyId();
            case SampleFieldType.PHENOTYPES -> {
                List<String> phenotypes = sampleContext.getPhenotypes();
                yield phenotypes.isEmpty() ? null : phenotypes;
            }
            default -> throw new UnexpectedEnumException(sampleField);
        };
    }

    private Object getNestedGTValue(NestedField field, SampleContext sampleContext) {
        Genotype genotype;
        Genotype genotype2 = genotype = sampleContext != null ? this.variantContext.getGenotype(sampleContext.getIndex()) : null;
        if (genotype == null) {
            return null;
        }
        GenotypeFieldType genotypeFieldType = GenotypeFieldType.valueOf(field.getId());
        return switch (genotypeFieldType) {
            case GenotypeFieldType.ALLELES -> genotype.getAlleles().stream().map(htsjdk.variant.variantcontext.Allele::getBaseString).toList();
            case GenotypeFieldType.ALLELE_NUM -> genotype.getAlleles().stream().map(allele -> this.variantContext.getAlleles().indexOf(allele)).toList();
            case GenotypeFieldType.TYPE -> {
                switch (genotype.getType()) {
                    case MIXED: {
                        yield GenotypeType.MIXED.name();
                    }
                    case HET: {
                        yield GenotypeType.HET.name();
                    }
                    case HOM_REF: {
                        yield GenotypeType.HOM_REF.name();
                    }
                    case HOM_VAR: {
                        yield GenotypeType.HOM_VAR.name();
                    }
                    case NO_CALL: {
                        yield GenotypeType.NO_CALL.name();
                    }
                    case UNAVAILABLE: {
                        yield GenotypeType.UNAVAILABLE.name();
                    }
                }
                throw new UnexpectedEnumException(genotype.getType());
            }
            case GenotypeFieldType.MIXED -> genotype.isMixed();
            case GenotypeFieldType.CALLED -> genotype.isCalled();
            case GenotypeFieldType.PLOIDY -> {
                int ploidy = genotype.getPloidy();
                yield ploidy != 0 ? Integer.valueOf(ploidy) : null;
            }
            case GenotypeFieldType.PHASED -> genotype.isPhased();
            case GenotypeFieldType.NON_INFORMATIVE -> genotype.isNonInformative();
            default -> throw new UnexpectedEnumException(genotypeFieldType);
        };
    }

    private Object getFormatField(Field field, SampleContext sampleContext) {
        Object typedValue;
        Genotype genotype = this.variantContext.getGenotype(sampleContext.getIndex());
        if (genotype == null) {
            return null;
        }
        switch (field.getId()) {
            case "GT": {
                String separator = genotype.isPhased() ? "|" : "/";
                typedValue = String.join((CharSequence)separator, genotype.getAlleles().stream().map(allele -> this.variantContext.getAlleles().indexOf(allele)).map(index -> this.mapAlleleString((Integer)index)).toList());
                break;
            }
            case "AD": {
                int[] ad = genotype.getAD();
                typedValue = ad != null ? IntStream.of(ad).boxed().toList() : null;
                break;
            }
            case "DP": {
                typedValue = genotype.getDP();
                if ((Integer)typedValue != -1) break;
                typedValue = null;
                break;
            }
            case "GQ": {
                int gq = genotype.getGQ();
                typedValue = gq != -1 ? Integer.valueOf(gq) : null;
                break;
            }
            case "PL": {
                int[] pl = genotype.getPL();
                typedValue = pl != null ? IntStream.of(pl).boxed().toList() : null;
                break;
            }
            default: {
                typedValue = this.getExtendedAttributeValue(field, genotype);
            }
        }
        return typedValue;
    }

    private String mapAlleleString(Integer index) {
        return index != -1 ? Integer.toString(index) : ".";
    }

    private Object getExtendedAttributeValue(Field field, Genotype genotype) {
        Object value = genotype.getExtendedAttribute(field.getId());
        if (value != null && !(value instanceof String)) {
            throw new UnsupportedFormatFieldException(value.getClass());
        }
        ValueCount valueCount = field.getValueCount();
        ValueCount.Type valueCountType = valueCount.getType();
        return switch (valueCountType) {
            case ValueCount.Type.A, ValueCount.Type.R, ValueCount.Type.VARIABLE -> value != null ? VcfUtils.getTypedVcfListValue(field, value.toString()) : null;
            case ValueCount.Type.FIXED -> {
                if (valueCount.getCount() == 1) {
                    yield value != null ? VcfUtils.getTypedVcfValue(field, value.toString()) : null;
                }
                yield value != null ? VcfUtils.getTypedVcfListValue(field, value.toString()) : null;
            }
            default -> throw new UnexpectedEnumException(valueCountType);
        };
    }

    public List<String> getVepValues(Field vepField) {
        return this.getVariantContext().getAttributeAsStringList(vepField.getId(), "");
    }

    private Object getNestedVepValue(Field field) {
        String singleValue;
        String[] split;
        String stringValue;
        Object value = null;
        NestedField nestedField = (NestedField)field;
        String separator = Pattern.quote(nestedField.getParent().getSeparator().toString());
        int index = nestedField.getIndex();
        String parentId = nestedField.getParent().getId();
        List<String> infoValues = VcfUtils.getInfoAsStringList(this.variantContext, parentId);
        if (!infoValues.isEmpty() && !(stringValue = (split = (singleValue = infoValues.get(0)).split(separator, -1))[index]).isEmpty()) {
            if (field.getSeparator() != null) {
                String nestedSeparator = Pattern.quote(nestedField.getSeparator().toString());
                value = VcfUtils.getTypedVcfValue(field, stringValue, nestedSeparator);
            } else {
                value = VcfUtils.getTypedVcfValue(field, stringValue);
            }
        }
        return value;
    }

    private Object getCommonValue(Field field, Allele allele) {
        return switch (field.getId()) {
            case "#CHROM" -> this.variantContext.getContig();
            case "POS" -> this.variantContext.getStart();
            case "ID" -> this.variantContext.hasID() ? Arrays.asList(this.variantContext.getID().split(";")) : Collections.emptyList();
            case "REF" -> this.variantContext.getReference().getBaseString();
            case "ALT" -> Arrays.asList(allele.getBases().split(","));
            case "QUAL" -> this.variantContext.hasLog10PError() ? Double.valueOf(this.variantContext.getPhredScaledQual()) : null;
            case "FILTER" -> this.getCommonFilterValue();
            default -> throw new UnknownFieldException(field.getId(), FieldType.COMMON);
        };
    }

    private Object getCommonFilterValue() {
        Set<String> filters = this.variantContext.getFiltersMaybeNull();
        List<Object> value = filters == null ? Collections.emptyList() : (filters.isEmpty() ? PASS_FILTER : (filters.size() == 1 ? List.of(filters.iterator().next()) : new ArrayList<String>(filters)));
        return value;
    }

    private Object getInfoValue(Field field, Allele allele) {
        ValueCount valueCount = field.getValueCount();
        ValueCount.Type valueCountType = valueCount.getType();
        return switch (valueCountType) {
            case ValueCount.Type.A -> {
                List<?> aInfoList = this.getInfoList(field);
                yield !aInfoList.isEmpty() ? aInfoList.get(allele.getIndex() - 1) : null;
            }
            case ValueCount.Type.R -> {
                List<?> rInfoList = this.getInfoList(field);
                yield !rInfoList.isEmpty() ? rInfoList.get(allele.getIndex()) : null;
            }
            case ValueCount.Type.VARIABLE -> this.getInfoList(field);
            case ValueCount.Type.FIXED -> valueCount.getCount() == 1 ? this.getInfo(field) : this.getInfoList(field);
            default -> throw new UnexpectedEnumException(valueCountType);
        };
    }

    private Object getInfo(Field field) {
        ValueType valueType = field.getValueType();
        return switch (valueType) {
            case ValueType.INTEGER -> VcfUtils.getInfoAsInteger(this.variantContext, field);
            case ValueType.FLAG -> VcfUtils.getInfoAsBoolean(this.variantContext, field);
            case ValueType.FLOAT -> VcfUtils.getInfoAsDouble(this.variantContext, field);
            case ValueType.CHARACTER, ValueType.STRING -> VcfUtils.getInfoAsString(this.variantContext, field);
            default -> throw new UnexpectedEnumException(valueType);
        };
    }

    private List<?> getInfoList(Field field) {
        ValueType valueType = field.getValueType();
        return switch (valueType) {
            case ValueType.INTEGER -> VcfUtils.getInfoAsIntegerList(this.variantContext, field);
            case ValueType.FLOAT -> VcfUtils.getInfoAsDoubleList(this.variantContext, field);
            case ValueType.CHARACTER, ValueType.STRING -> VcfUtils.getInfoAsStringList(this.variantContext, field);
            case ValueType.FLAG -> throw new FlagListException(field.getId());
            default -> throw new UnexpectedEnumException(valueType);
        };
    }

    public void setAttribute(Field attribute, Object value) {
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder(this.variantContext);
        variantContextBuilder.attribute(attribute.getId(), value);
        this.variantContext = variantContextBuilder.make();
    }

    public VariantContext unwrap() {
        return this.variantContext;
    }

    public String toDisplayString() {
        return String.format("%s:%s %s", this.variantContext.getContig(), this.variantContext.getStart(), this.variantContext.getReference().getBaseString());
    }

    public VcfRecord getFilteredCopy(String consequence, Field vepField) {
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder(this.variantContext);
        variantContextBuilder.attribute(vepField.getId(), List.of(consequence));
        VariantContext filterVariantContext = variantContextBuilder.make();
        return new VcfRecord(filterVariantContext);
    }
}

