/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import htsjdk.variant.vcf.VCFFileReader;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.VcfRecord;
import org.molgenis.vcf.decisiontree.runner.info.GenotypeMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataParser;

public class VcfReader
implements AutoCloseable {
    private final VCFFileReader vcfFileReader;
    private final VepMetadataParser vepMetadataParser;
    private final boolean strict;
    private final GenotypeMetadataMapper genotypeMetadataMapper;
    private boolean inited = false;
    private NestedHeaderLine vepNestedHeaderLine = null;
    private NestedHeaderLine gtNestedHeaderLine = null;

    public VcfReader(VCFFileReader vcfFileReader, VepMetadataParser vepMetadataParser, GenotypeMetadataMapper genotypeMetadataMapper, boolean strict) {
        this.vcfFileReader = Objects.requireNonNull(vcfFileReader);
        this.vepMetadataParser = Objects.requireNonNull(vepMetadataParser);
        this.genotypeMetadataMapper = Objects.requireNonNull(genotypeMetadataMapper);
        this.strict = strict;
    }

    private void initNestedMeta() {
        if (!this.inited) {
            this.vepNestedHeaderLine = this.vepMetadataParser.map(this.vcfFileReader.getFileHeader());
            this.gtNestedHeaderLine = this.genotypeMetadataMapper.map();
            this.inited = true;
        }
    }

    public Stream<VcfRecord> stream() {
        return StreamSupport.stream(this.vcfFileReader.spliterator(), false).map(VcfRecord::new);
    }

    public VcfMetadata getMetadata() {
        this.initNestedMeta();
        return new VcfMetadata(this.vcfFileReader.getFileHeader(), this.vepNestedHeaderLine, this.gtNestedHeaderLine, this.strict);
    }

    @Override
    public void close() {
        this.vcfFileReader.close();
    }
}

