/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.molgenis.vcf.decisiontree.UnexpectedEnumException;
import org.molgenis.vcf.decisiontree.filter.InvalidNumberOfTokensException;
import org.molgenis.vcf.decisiontree.filter.UnknownFieldException;
import org.molgenis.vcf.decisiontree.filter.UnsupportedFieldException;
import org.molgenis.vcf.decisiontree.filter.UnsupportedNestedFieldException;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldImpl;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.MissingField;
import org.molgenis.vcf.decisiontree.filter.model.ValueCount;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.molgenis.vcf.decisiontree.utils.VcfUtils;

public class VcfMetadata {
    private final VCFHeader vcfHeader;
    private final boolean strict;
    private final NestedHeaderLine nestedVepHeaderLine;
    private final NestedHeaderLine nestedGenotypeHeaderLine;

    public VcfMetadata(VCFHeader vcfHeader, NestedHeaderLine nestedVepHeaderLine, NestedHeaderLine nestedGenotypeHeaderLine, boolean strict) {
        this.vcfHeader = Objects.requireNonNull(vcfHeader);
        this.nestedVepHeaderLine = Objects.requireNonNull(nestedVepHeaderLine);
        this.nestedGenotypeHeaderLine = Objects.requireNonNull(nestedGenotypeHeaderLine);
        this.strict = Objects.requireNonNull(strict);
    }

    public Field getField(String fieldId) {
        List<String> fieldTokens = Arrays.asList(fieldId.split("/"));
        FieldType fieldType = VcfUtils.toFieldType(fieldTokens);
        return switch (fieldType) {
            case FieldType.COMMON -> this.toCommonField(fieldTokens);
            case FieldType.INFO, FieldType.FORMAT -> this.toCompoundField(fieldTokens, fieldType);
            case FieldType.SAMPLE -> this.toSampleField(fieldTokens);
            case FieldType.INFO_VEP -> this.toNestedField(fieldTokens, fieldType, this.nestedVepHeaderLine);
            case FieldType.GENOTYPE -> this.toNestedField(fieldTokens, fieldType, this.nestedGenotypeHeaderLine);
            default -> throw new UnexpectedEnumException(fieldType);
        };
    }

    private Field toSampleField(List<String> fieldTokens) {
        ValueType valueType;
        if (fieldTokens.size() != 2) {
            throw new InvalidNumberOfTokensException(fieldTokens, FieldType.SAMPLE, 2);
        }
        String field = fieldTokens.get(1);
        return FieldImpl.builder().id(field).fieldType(FieldType.SAMPLE).valueType(valueType).valueCount(switch (field.toUpperCase()) {
            case "PROBAND" -> {
                valueType = ValueType.FLAG;
                yield ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build();
            }
            case "AFFECTED_STATUS", "SEX", "FATHER", "MOTHER", "FAMILY" -> {
                valueType = ValueType.STRING;
                yield ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build();
            }
            case "PHENOTYPES" -> {
                valueType = ValueType.STRING;
                yield ValueCount.builder().type(ValueCount.Type.VARIABLE).nullable(true).build();
            }
            default -> throw new UnsupportedFieldException(field);
        }).build();
    }

    private Field toNestedField(List<String> fieldTokens, FieldType fieldType, NestedHeaderLine nestedHeaderLine) {
        if (fieldTokens.size() != 3) {
            throw new InvalidNumberOfTokensException(fieldTokens, fieldType, 2);
        }
        String field = fieldTokens.get(1);
        String nestedFieldId = fieldTokens.get(2);
        if (!field.equals(nestedHeaderLine.getParentField().getId())) {
            if (this.strict) {
                throw new UnsupportedNestedFieldException(field);
            }
            return new MissingField(field);
        }
        Field nestedField = nestedHeaderLine.getField(nestedFieldId);
        if (nestedField instanceof MissingField && this.strict) {
            throw new UnknownFieldException(nestedFieldId, FieldType.INFO_VEP);
        }
        return nestedField;
    }

    private FieldImpl toCommonField(List<String> fieldTokens) {
        ValueType valueType;
        String field;
        if (fieldTokens.size() > 1) {
            throw new InvalidNumberOfTokensException(fieldTokens, FieldType.COMMON, 1);
        }
        return FieldImpl.builder().id(field).fieldType(FieldType.COMMON).valueType(valueType).valueCount(switch (field = fieldTokens.get(0)) {
            case "#CHROM", "REF" -> {
                valueType = ValueType.STRING;
                yield ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build();
            }
            case "POS" -> {
                valueType = ValueType.INTEGER;
                yield ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build();
            }
            case "ID", "FILTER", "ALT" -> {
                valueType = ValueType.STRING;
                yield ValueCount.builder().type(ValueCount.Type.VARIABLE).nullable(true).build();
            }
            case "QUAL" -> {
                valueType = ValueType.FLOAT;
                yield ValueCount.builder().type(ValueCount.Type.FIXED).count(1).nullable(true).build();
            }
            default -> throw new UnsupportedFieldException(field);
        }).build();
    }

    private Field toCompoundField(List<String> fieldTokens, FieldType fieldType) {
        if (fieldTokens.size() != 2) {
            throw new InvalidNumberOfTokensException(fieldTokens, fieldType, 2);
        }
        String field = fieldTokens.get(1);
        VCFCompoundHeaderLine vcfCompoundHeaderLine = this.getVcfCompoundHeaderLine(fieldType, field);
        if (vcfCompoundHeaderLine == null) {
            return new MissingField(field);
        }
        VCFHeaderLineType lineType = vcfCompoundHeaderLine.getType();
        ValueType valueType = switch (lineType) {
            case VCFHeaderLineType.Integer -> ValueType.INTEGER;
            case VCFHeaderLineType.Float -> ValueType.FLOAT;
            case VCFHeaderLineType.String -> ValueType.STRING;
            case VCFHeaderLineType.Character -> ValueType.CHARACTER;
            case VCFHeaderLineType.Flag -> ValueType.FLAG;
            default -> throw new UnexpectedEnumException(lineType);
        };
        ValueCount.ValueCountBuilder builder = ValueCount.builder();
        VCFHeaderLineCount countType = vcfCompoundHeaderLine.getCountType();
        switch (countType) {
            case INTEGER: {
                int count = vcfCompoundHeaderLine.getCount();
                builder.type(ValueCount.Type.FIXED).count(count).nullable(valueType != ValueType.FLAG);
                break;
            }
            case A: {
                builder.type(ValueCount.Type.A).nullable(true);
                break;
            }
            case R: {
                builder.type(ValueCount.Type.R).nullable(true);
                break;
            }
            case G: {
                builder.type(ValueCount.Type.G).nullable(true);
                break;
            }
            case UNBOUNDED: {
                builder.type(ValueCount.Type.VARIABLE).nullable(true);
                break;
            }
            default: {
                throw new UnexpectedEnumException(countType);
            }
        }
        return FieldImpl.builder().id(field).fieldType(fieldType).valueType(valueType).valueCount(builder.build()).build();
    }

    private VCFCompoundHeaderLine getVcfCompoundHeaderLine(FieldType fieldType, String field) {
        VCFCompoundHeaderLine vcfCompoundHeaderLine;
        switch (fieldType) {
            case FORMAT: {
                vcfCompoundHeaderLine = this.vcfHeader.getFormatHeaderLine(field);
                if (vcfCompoundHeaderLine != null || !this.strict) break;
                throw new UnknownFieldException(field, fieldType);
            }
            case INFO: {
                vcfCompoundHeaderLine = this.vcfHeader.getInfoHeaderLine(field);
                if (vcfCompoundHeaderLine != null || !this.strict) break;
                throw new UnknownFieldException(field, FieldType.INFO_VEP);
            }
            default: {
                throw new UnexpectedEnumException(fieldType);
            }
        }
        return vcfCompoundHeaderLine;
    }

    public static boolean isSingleValueField(Field field) {
        return field.getValueCount().getType() == ValueCount.Type.FIXED && field.getValueCount().getCount() == 1;
    }

    public Map<String, Integer> getSampleNameToOffset() {
        return this.vcfHeader.getSampleNameToOffset();
    }

    public VCFHeader unwrap() {
        return this.vcfHeader;
    }

    public NestedHeaderLine getVepHeaderLine() {
        return this.nestedVepHeaderLine;
    }
}

