/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import org.molgenis.vcf.decisiontree.UnexpectedEnumException;
import org.molgenis.vcf.decisiontree.filter.BoolMultiNodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.BoolNodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.CategoricalNodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.ExistsNodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.NodeEvaluatorService;
import org.molgenis.vcf.decisiontree.filter.Variant;
import org.molgenis.vcf.decisiontree.filter.model.BoolMultiNode;
import org.molgenis.vcf.decisiontree.filter.model.BoolNode;
import org.molgenis.vcf.decisiontree.filter.model.CategoricalNode;
import org.molgenis.vcf.decisiontree.filter.model.DecisionNode;
import org.molgenis.vcf.decisiontree.filter.model.DecisionType;
import org.molgenis.vcf.decisiontree.filter.model.ExistsNode;
import org.molgenis.vcf.decisiontree.filter.model.NodeOutcome;
import org.molgenis.vcf.decisiontree.filter.model.SampleContext;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class NodeEvaluatorServiceImpl
implements NodeEvaluatorService {
    private final BoolNodeEvaluator boolNodeEvaluator;
    private final CategoricalNodeEvaluator categoricalNodeEvaluator;
    private final ExistsNodeEvaluator existsNodeEvaluator;
    private final BoolMultiNodeEvaluator boolMultiNodeEvaluator;

    NodeEvaluatorServiceImpl() {
        this.boolNodeEvaluator = new BoolNodeEvaluator();
        this.boolMultiNodeEvaluator = new BoolMultiNodeEvaluator();
        this.categoricalNodeEvaluator = new CategoricalNodeEvaluator();
        this.existsNodeEvaluator = new ExistsNodeEvaluator();
    }

    NodeEvaluatorServiceImpl(BoolNodeEvaluator boolNodeEvaluator, BoolMultiNodeEvaluator boolMultiNodeEvaluator, CategoricalNodeEvaluator categoricalNodeEvaluator, ExistsNodeEvaluator existsNodeEvaluator) {
        this.boolNodeEvaluator = boolNodeEvaluator;
        this.boolMultiNodeEvaluator = boolMultiNodeEvaluator;
        this.categoricalNodeEvaluator = categoricalNodeEvaluator;
        this.existsNodeEvaluator = existsNodeEvaluator;
    }

    @Override
    public NodeOutcome evaluate(DecisionNode node, Variant variant, @Nullable SampleContext sampleContext) {
        DecisionType decisionType = node.getDecisionType();
        return switch (decisionType) {
            case DecisionType.EXISTS -> this.existsNodeEvaluator.evaluate((ExistsNode)node, variant, sampleContext);
            case DecisionType.BOOL -> this.boolNodeEvaluator.evaluate((BoolNode)node, variant, sampleContext);
            case DecisionType.BOOL_MULTI -> this.boolMultiNodeEvaluator.evaluate((BoolMultiNode)node, variant, sampleContext);
            case DecisionType.CATEGORICAL -> this.categoricalNodeEvaluator.evaluate((CategoricalNode)node, variant, sampleContext);
            default -> throw new UnexpectedEnumException(decisionType);
        };
    }
}

