/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.molgenis.vcf.decisiontree.filter.DecisionTreeExecutor;
import org.molgenis.vcf.decisiontree.filter.NodeEvaluatorService;
import org.molgenis.vcf.decisiontree.filter.Variant;
import org.molgenis.vcf.decisiontree.filter.model.Decision;
import org.molgenis.vcf.decisiontree.filter.model.DecisionNode;
import org.molgenis.vcf.decisiontree.filter.model.DecisionTree;
import org.molgenis.vcf.decisiontree.filter.model.Label;
import org.molgenis.vcf.decisiontree.filter.model.LeafNode;
import org.molgenis.vcf.decisiontree.filter.model.Node;
import org.molgenis.vcf.decisiontree.filter.model.NodeOutcome;
import org.molgenis.vcf.decisiontree.filter.model.NodeType;
import org.molgenis.vcf.decisiontree.filter.model.SampleContext;

public class DecisionTreeExecutorImpl
implements DecisionTreeExecutor {
    private final NodeEvaluatorService nodeEvaluatorService;
    private final boolean storeLabels;
    private final boolean storePaths;

    public DecisionTreeExecutorImpl(NodeEvaluatorService nodeEvaluatorService) {
        this(nodeEvaluatorService, false, false);
    }

    public DecisionTreeExecutorImpl(NodeEvaluatorService nodeEvaluatorService, boolean storeLabels, boolean storePaths) {
        this.nodeEvaluatorService = Objects.requireNonNull(nodeEvaluatorService);
        this.storeLabels = storeLabels;
        this.storePaths = storePaths;
    }

    @Override
    public Decision execute(DecisionTree tree, Variant variant, SampleContext sampleContext) {
        ArrayList<Node> nodePath = this.storePaths ? new ArrayList<Node>() : List.of();
        HashSet<Label> labels = this.storeLabels ? new HashSet<Label>() : Set.of();
        Node currentNode = tree.getRootNode();
        while (true) {
            if (this.storePaths) {
                nodePath.add(currentNode);
            }
            if (currentNode.getNodeType() == NodeType.LEAF) break;
            NodeOutcome nodeOutcome = this.nodeEvaluatorService.evaluate((DecisionNode)currentNode, variant, sampleContext);
            if (this.storeLabels) {
                this.storeLabel(nodeOutcome, labels);
            }
            currentNode = nodeOutcome.getNextNode();
        }
        return new Decision(((LeafNode)currentNode).getClazz(), nodePath, labels);
    }

    private void storeLabel(NodeOutcome nodeOutcome, Set<Label> labels) {
        Label label = nodeOutcome.getLabel();
        if (label != null) {
            labels.add(label);
        }
    }
}

