/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import org.molgenis.vcf.decisiontree.filter.ConsequenceAnnotator;
import org.molgenis.vcf.decisiontree.filter.DecisionUtils;
import org.molgenis.vcf.decisiontree.filter.model.Decision;

public class ConsequenceAnnotatorImpl
implements ConsequenceAnnotator {
    private final boolean writeLabels;
    private final boolean writePaths;

    public ConsequenceAnnotatorImpl(boolean writeLabels, boolean writePaths) {
        this.writeLabels = writeLabels;
        this.writePaths = writePaths;
    }

    @Override
    public String annotate(Decision decision, String consequence) {
        StringBuilder csqBuilder = new StringBuilder(consequence);
        csqBuilder.append("|");
        csqBuilder.append(DecisionUtils.getDecisionClass(decision));
        if (this.writePaths) {
            csqBuilder.append("|");
            csqBuilder.append(DecisionUtils.getDecisionsPath(decision));
        }
        if (this.writeLabels) {
            csqBuilder.append("|");
            csqBuilder.append(DecisionUtils.getDecisionLabelsString(decision));
        }
        return csqBuilder.toString();
    }
}

