/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import org.molgenis.vcf.decisiontree.filter.BaseBoolNodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.EvaluationException;
import org.molgenis.vcf.decisiontree.filter.Variant;
import org.molgenis.vcf.decisiontree.filter.model.BoolMultiNode;
import org.molgenis.vcf.decisiontree.filter.model.BoolMultiQuery;
import org.molgenis.vcf.decisiontree.filter.model.BoolQuery;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.MissingField;
import org.molgenis.vcf.decisiontree.filter.model.NodeOutcome;
import org.molgenis.vcf.decisiontree.filter.model.SampleContext;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class BoolMultiNodeEvaluator
implements BaseBoolNodeEvaluator<BoolMultiNode> {
    @Override
    public NodeOutcome evaluate(BoolMultiNode node, Variant variant, @Nullable SampleContext sampleContext) {
        if (this.containsMissingFields(node, variant)) {
            return node.getOutcomeMissing();
        }
        for (BoolMultiQuery clause : node.getClauses()) {
            if (this.evaluateClause(variant, clause, sampleContext) == TripleBoolean.MISSING) {
                return node.getOutcomeMissing();
            }
            if (this.evaluateClause(variant, clause, sampleContext) != TripleBoolean.TRUE) continue;
            return clause.getOutcomeTrue();
        }
        return node.getOutcomeDefault();
    }

    private boolean containsMissingFields(BoolMultiNode node, Variant variant) {
        for (Field field : node.getFields()) {
            if (!(field instanceof MissingField)) continue;
            if (node.getOutcomeMissing() != null) {
                return true;
            }
            throw new EvaluationException(node, variant, "missing 'missingOutcome'");
        }
        return false;
    }

    private TripleBoolean evaluateClause(Variant variant, BoolMultiQuery clause, @Nullable SampleContext sampleContext) {
        TripleBoolean outcome = TripleBoolean.FALSE;
        if (clause.getQueryList().size() == 1) {
            BoolQuery query = clause.getQueryList().get(0);
            Object value = variant.getValue((query = this.postProcessQuery(query, variant, sampleContext)).getField(), sampleContext);
            if (this.isMissingValue(value)) {
                outcome = TripleBoolean.MISSING;
            } else if (this.executeQuery(query, value)) {
                outcome = TripleBoolean.TRUE;
            }
        } else if (this.evaluateMultiQuery(clause, variant, sampleContext)) {
            outcome = TripleBoolean.TRUE;
        }
        return outcome;
    }

    private boolean evaluateMultiQuery(BoolMultiQuery clause, Variant variant, SampleContext sampleContext) {
        if (clause.getOperator() == BoolMultiQuery.Operator.AND) {
            if (this.allQueriesMatch(clause, variant, sampleContext)) {
                return true;
            }
        } else {
            for (BoolQuery query : clause.getQueryList()) {
                Object value = variant.getValue(query.getField(), sampleContext);
                if (this.isMissingValue(value) || !this.executeQuery(query, value)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean allQueriesMatch(BoolMultiQuery clause, Variant variant, SampleContext sampleContext) {
        for (BoolQuery query : clause.getQueryList()) {
            Object value = variant.getValue((query = this.postProcessQuery(query, variant, sampleContext)).getField(), sampleContext);
            if (!this.isMissingValue(value) && this.executeQuery(query, value)) continue;
            return false;
        }
        return true;
    }

    public static enum TripleBoolean {
        TRUE,
        FALSE,
        MISSING;

    }
}

