/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import java.util.Collection;
import org.molgenis.vcf.decisiontree.UnexpectedEnumException;
import org.molgenis.vcf.decisiontree.filter.NodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.Variant;
import org.molgenis.vcf.decisiontree.filter.model.BoolQuery;
import org.molgenis.vcf.decisiontree.filter.model.DecisionNode;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.SampleContext;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.springframework.lang.Nullable;

interface BaseBoolNodeEvaluator<T extends DecisionNode>
extends NodeEvaluator<T> {
    default public boolean isMissingValue(Object value) {
        return value == null || value instanceof Collection && ((Collection)value).isEmpty();
    }

    default public boolean executeQuery(BoolQuery boolQuery, Object value) {
        Field field = boolQuery.getField();
        BoolQuery.Operator operator = boolQuery.getOperator();
        Object queryValue = boolQuery.getValue();
        return switch (operator) {
            case BoolQuery.Operator.EQUALS -> value.equals(queryValue);
            case BoolQuery.Operator.NOT_EQUALS -> !value.equals(queryValue);
            case BoolQuery.Operator.LESS -> this.executeLessQuery(field, value, queryValue);
            case BoolQuery.Operator.LESS_OR_EQUAL -> !this.executeGreaterQuery(field, value, queryValue);
            case BoolQuery.Operator.GREATER -> this.executeGreaterQuery(field, value, queryValue);
            case BoolQuery.Operator.GREATER_OR_EQUAL -> !this.executeLessQuery(field, value, queryValue);
            case BoolQuery.Operator.IN -> this.executeInQuery(value, (Collection)queryValue);
            case BoolQuery.Operator.NOT_IN -> !this.executeInQuery(value, (Collection)queryValue);
            case BoolQuery.Operator.CONTAINS -> this.executeContainsQuery((Collection)value, queryValue);
            case BoolQuery.Operator.NOT_CONTAINS -> !this.executeContainsQuery((Collection)value, queryValue);
            case BoolQuery.Operator.CONTAINS_ALL -> this.executeContainsAllQuery((Collection)value, (Collection)queryValue);
            case BoolQuery.Operator.CONTAINS_ANY -> this.executeContainsAnyQuery((Collection)value, (Collection)queryValue);
            case BoolQuery.Operator.CONTAINS_NONE -> this.executeContainsNoneQuery((Collection)value, (Collection)queryValue);
            default -> throw new UnexpectedEnumException(operator);
        };
    }

    default public boolean executeLessQuery(Field field, Object value, Object queryValue) {
        return switch (field.getValueType()) {
            case ValueType.INTEGER -> (Integer)value < (Integer)queryValue;
            case ValueType.FLOAT -> (Double)value < (Double)queryValue;
            default -> throw new UnexpectedEnumException(field.getValueType());
        };
    }

    default public boolean executeGreaterQuery(Field field, Object value, Object queryValue) {
        return switch (field.getValueType()) {
            case ValueType.INTEGER -> (Integer)value > (Integer)queryValue;
            case ValueType.FLOAT -> (Double)value > (Double)queryValue;
            default -> throw new UnexpectedEnumException(field.getValueType());
        };
    }

    default public boolean executeContainsQuery(Collection<?> values, Object queryValue) {
        return values.contains(queryValue);
    }

    default public boolean executeContainsAllQuery(Collection<?> values, Collection<?> queryValues) {
        return values.containsAll(queryValues);
    }

    default public boolean executeContainsAnyQuery(Collection<?> values, Collection<?> queryValues) {
        for (Object queryValue : queryValues) {
            if (!values.contains(queryValue)) continue;
            return true;
        }
        return false;
    }

    default public boolean executeContainsNoneQuery(Collection<?> values, Collection<?> queryValues) {
        return !this.executeContainsAnyQuery(values, queryValues);
    }

    default public boolean executeInQuery(Object value, Collection<?> queryValues) {
        return queryValues.contains(value);
    }

    default public BoolQuery postProcessQuery(BoolQuery query, Variant variant, @Nullable SampleContext sampleContext) {
        String stringQueryValue = query.getValue().toString();
        if (stringQueryValue.startsWith("field:")) {
            String fieldId = stringQueryValue.substring("field:".length());
            query = BoolQuery.builder().field(query.getField()).operator(query.getOperator()).value(variant.getValue(variant.getVcfMetadata().getField(fieldId), sampleContext)).build();
        }
        return query;
    }
}

