/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.molgenis.vcf.decisiontree.AppSettings;
import org.molgenis.vcf.decisiontree.SampleSettings;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.WriterSettings;
import org.molgenis.vcf.decisiontree.filter.model.Mode;
import org.molgenis.vcf.decisiontree.loader.ConfigDecisionTreeLoader;
import org.molgenis.vcf.decisiontree.loader.model.ConfigDecisionTree;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
class AppCommandLineToSettingsMapper {
    private final String appName;
    private final String appVersion;
    private final ConfigDecisionTreeLoader configDecisionTreeLoader;

    AppCommandLineToSettingsMapper(@Value(value="${app.name}") String appName, @Value(value="${app.version}") String appVersion, ConfigDecisionTreeLoader configDecisionTreeLoader) {
        this.appName = appName;
        this.appVersion = appVersion;
        this.configDecisionTreeLoader = Objects.requireNonNull(configDecisionTreeLoader);
    }

    Settings map(CommandLine commandLine, String ... args) {
        AppSettings appSettings = this.createAppSettings(args);
        Path inputPath = Path.of(commandLine.getOptionValue("i"), new String[0]);
        ConfigDecisionTree configDecisionTree = this.createDecisionTree(commandLine);
        WriterSettings writerSettings = this.createWriterSettings(commandLine);
        boolean strict = commandLine.hasOption("s");
        Mode mode = this.getMode(commandLine);
        SampleSettings sampleSettings = this.createSampleSettings(commandLine);
        return Settings.builder().mode(mode).inputVcfPath(inputPath).configDecisionTree(configDecisionTree).appSettings(appSettings).writerSettings(writerSettings).strict(strict).sampleSettings(sampleSettings).build();
    }

    private Mode getMode(CommandLine commandLine) {
        Mode mode = commandLine.hasOption("m") ? Mode.valueOf(commandLine.getOptionValue("m").toUpperCase()) : Mode.VARIANT;
        return mode;
    }

    private SampleSettings createSampleSettings(CommandLine commandLine) {
        String phenotypesString = "";
        if (commandLine.hasOption("ph")) {
            phenotypesString = commandLine.getOptionValue("ph");
        }
        List<String> probandNames = List.of();
        if (commandLine.hasOption("pb")) {
            probandNames = Arrays.asList(commandLine.getOptionValue("pb").split(","));
        }
        List<Path> pedPaths = List.of();
        if (commandLine.hasOption("pd")) {
            pedPaths = AppCommandLineToSettingsMapper.parsePaths(commandLine.getOptionValue("pd"));
        }
        return new SampleSettings(probandNames, pedPaths, phenotypesString);
    }

    private ConfigDecisionTree createDecisionTree(CommandLine commandLine) {
        Path configPath = Path.of(commandLine.getOptionValue("c"), new String[0]);
        return this.configDecisionTreeLoader.load(configPath);
    }

    private AppSettings createAppSettings(String ... args) {
        return AppSettings.builder().name(this.appName).version(this.appVersion).args(Arrays.asList(args)).build();
    }

    private WriterSettings createWriterSettings(CommandLine commandLine) {
        Path outputPath = commandLine.hasOption("o") ? Path.of(commandLine.getOptionValue("o"), new String[0]) : Path.of(commandLine.getOptionValue("i").replace(".vcf", ".out.vcf"), new String[0]);
        boolean overwriteOutput = commandLine.hasOption("f");
        boolean writeLabels = commandLine.hasOption("l");
        boolean writePath = commandLine.hasOption("p");
        return WriterSettings.builder().outputVcfPath(outputPath).overwriteOutput(overwriteOutput).writeLabels(writeLabels).writePath(writePath).build();
    }

    private static List<Path> parsePaths(String optionValue) {
        String[] paths;
        ArrayList<Path> result = new ArrayList<Path>();
        for (String path : paths = optionValue.split(",")) {
            result.add(Path.of(path, new String[0]));
        }
        return result;
    }
}

