/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

public class AlignmentSpan {
    public static final AlignmentSpan UNPLACED_SPAN = new AlignmentSpan(-1, 0, 0, 0);
    private final int start;
    private final int span;
    private final int mappedCount;
    private final int unmappedCount;

    public AlignmentSpan(int start, int span, int mappedCount, int unmappedCount) {
        this.start = start;
        this.span = span;
        this.mappedCount = mappedCount;
        this.unmappedCount = unmappedCount;
    }

    public static AlignmentSpan combine(AlignmentSpan a, AlignmentSpan b) {
        int start = Math.min(a.getStart(), b.getStart());
        int span = a.getStart() == b.getStart() ? Math.max(a.getSpan(), b.getSpan()) : Math.max(a.getStart() + a.getSpan(), b.getStart() + b.getSpan()) - start;
        int mappedCount = a.mappedCount + b.mappedCount;
        int unmappedCount = a.unmappedCount + b.unmappedCount;
        return new AlignmentSpan(start, span, mappedCount, unmappedCount);
    }

    public int getStart() {
        return this.start;
    }

    public int getSpan() {
        return this.span;
    }

    public int getMappedCount() {
        return this.mappedCount;
    }

    public int getUnmappedCount() {
        return this.unmappedCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlignmentSpan that = (AlignmentSpan)o;
        if (this.start != that.start) {
            return false;
        }
        if (this.span != that.span) {
            return false;
        }
        if (this.mappedCount != that.mappedCount) {
            return false;
        }
        return this.unmappedCount == that.unmappedCount;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.span;
        result = 31 * result + this.mappedCount;
        result = 31 * result + this.unmappedCount;
        return result;
    }
}

