/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.molgenis.vcf.report.fasta.ContigInterval;

public class IntervalUtils {
    private IntervalUtils() {
    }

    public static List<ContigInterval> mergeIntervals(List<ContigInterval> intervals) {
        ArrayList<ContigInterval> mergedIntervals = new ArrayList();
        if (intervals.size() < 2) {
            mergedIntervals = intervals;
        } else {
            Collections.sort(intervals, Comparator.comparingInt(ContigInterval::getStart));
            ContigInterval interval = intervals.get(0);
            for (int i = 1; i < intervals.size(); ++i) {
                ContigInterval nextInterval = intervals.get(i);
                if (nextInterval.getStart() <= interval.getStop() + 1) {
                    int stop = interval.getStop() < nextInterval.getStop() ? nextInterval.getStop() : interval.getStop();
                    interval = new ContigInterval(interval.getContig(), interval.getStart(), stop);
                    continue;
                }
                mergedIntervals.add(interval);
                interval = nextInterval;
            }
            mergedIntervals.add(interval);
        }
        return mergedIntervals;
    }
}

