/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.utils;

import java.util.Arrays;
import org.molgenis.vcf.report.utils.Base85;

public class Base85 {
    private static final long POWER_4 = 52200625L;
    private static final long POWER_3 = 614125L;
    private static final long POWER_2 = 7225L;
    private static Encoder RFC1924ENCODER;
    private static Encoder Z85ENCODER;
    private static Encoder ASCII85ENCODER;
    private static Decoder RFC1924DECODER;
    private static Decoder Z85DECODER;
    private static Decoder ASCII85DECODER;

    private static void buildDecodeMap(byte[] encodeMap, byte[] decodeMap) {
        Arrays.fill(decodeMap, (byte)-1);
        byte len = (byte)encodeMap.length;
        for (byte i = 0; i < len; i = (byte)(i + 1)) {
            byte b = encodeMap[i];
            decodeMap[b] = i;
        }
    }

    public static Encoder getRfc1924Encoder() {
        if (RFC1924ENCODER == null) {
            RFC1924ENCODER = new Rfc1924Encoder();
        }
        return RFC1924ENCODER;
    }

    public static Decoder getRfc1924Decoder() {
        if (RFC1924DECODER == null) {
            RFC1924DECODER = new Rfc1924Decoder();
        }
        return RFC1924DECODER;
    }

    public static Encoder getZ85Encoder() {
        if (Z85ENCODER == null) {
            Z85ENCODER = new Z85Encoder();
        }
        return Z85ENCODER;
    }

    public static Decoder getZ85Decoder() {
        if (Z85DECODER == null) {
            Z85DECODER = new Z85Decoder();
        }
        return Z85DECODER;
    }

    public static Encoder getAscii85Encoder() {
        if (ASCII85ENCODER == null) {
            ASCII85ENCODER = new Ascii85Encoder();
        }
        return ASCII85ENCODER;
    }

    public static Decoder getAscii85Decoder() {
        if (ASCII85DECODER == null) {
            ASCII85DECODER = new Ascii85Decoder();
        }
        return ASCII85DECODER;
    }

    public static void main(String[] args) {
    }
}

