/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.genes;

import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.gff.Gff3Codec;
import htsjdk.tribble.gff.Gff3Feature;
import htsjdk.tribble.gff.Gff3Writer;
import htsjdk.variant.vcf.VCFIterator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.molgenis.vcf.report.fasta.ContigInterval;
import org.molgenis.vcf.report.fasta.VariantIntervalCalculator;
import org.molgenis.vcf.report.generator.SampleSettings;
import org.molgenis.vcf.report.utils.BestCompressionGZIPOutputStream;

public class GenesFilter {
    private static final List<String> FEATURE_SOURCES = List.of("BestRefSeq", "Curated Genomic");
    private static final List<String> FEATURE_TYPES = List.of("transcript", "primary_transcript", "exon", "mRNA", "pseudogene", "gene");
    private final VariantIntervalCalculator variantIntervalCalculator;
    private final Path genesFile;

    public GenesFilter(VariantIntervalCalculator variantIntervalCalculator, Path genesFile) {
        this.variantIntervalCalculator = Objects.requireNonNull(variantIntervalCalculator);
        this.genesFile = Objects.requireNonNull(genesFile);
    }

    public byte[] filter(VCFIterator vcfIterator, Map<String, SampleSettings.CramPath> cramPaths, Path reference) {
        List contigIntervals = this.variantIntervalCalculator.calculate(vcfIterator, cramPaths, reference);
        return this.filter(contigIntervals);
    }

    private byte[] filter(List<ContigInterval> contigIntervals) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Gff3Codec codec = new Gff3Codec(Gff3Codec.DecodeDepth.SHALLOW);
        try (AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader((String)this.genesFile.toAbsolutePath().toString(), null, (FeatureCodec)codec, (boolean)false);
             Gff3Writer writer = new Gff3Writer((OutputStream)output);){
            for (Gff3Feature feature : reader.iterator()) {
                boolean isAdded = false;
                for (ContigInterval contigInterval : contigIntervals) {
                    if (isAdded || !feature.getContig().equals(contigInterval.getContig()) || !this.isOverlappingFeature(feature, contigInterval) || !FEATURE_TYPES.contains(feature.getType()) || !FEATURE_SOURCES.contains(feature.getSource())) continue;
                    writer.addFeature(feature);
                    isAdded = true;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return BestCompressionGZIPOutputStream.compress((byte[])output.toByteArray());
    }

    private boolean isOverlappingFeature(Gff3Feature feature, ContigInterval contigInterval) {
        return feature.getStart() >= contigInterval.getStart() && feature.getStart() <= contigInterval.getStop() || feature.getEnd() >= contigInterval.getStart() && feature.getEnd() <= contigInterval.getStop() || feature.getStart() <= contigInterval.getStart() && feature.getEnd() >= contigInterval.getStop();
    }
}

