/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.generator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.molgenis.vcf.report.generator.Base85Encoder;
import org.molgenis.vcf.report.generator.ReportWriterSettings;
import org.molgenis.vcf.report.model.Report;
import org.molgenis.vcf.report.utils.BestCompressionGZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReportWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportWriter.class);
    private final Base85Encoder base85Encoder;

    public ReportWriter(Base85Encoder base85Encoder) {
        this.base85Encoder = Objects.requireNonNull(base85Encoder);
    }

    public void write(Report report, Path outputFile, ReportWriterSettings reportWriterSettings) {
        try {
            this.writeCheckedException(report, outputFile, reportWriterSettings);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeCheckedException(Report report, Path outputFile, ReportWriterSettings reportWriterSettings) throws IOException {
        Path templatePath = reportWriterSettings.getTemplatePath();
        LOGGER.info("creating report using template {}", (Object)templatePath);
        String templateHtml = Files.readString(templatePath, StandardCharsets.UTF_8);
        String scriptTag = this.createScriptTag(report, reportWriterSettings.isPrettyPrint());
        String reportHtml = templateHtml.contains("<script") ? templateHtml.replace("</title>", "</title>" + scriptTag) : templateHtml.replace("</head>", scriptTag + "</head>");
        Files.writeString(outputFile, (CharSequence)reportHtml, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private String createScriptTag(Report report, boolean prettyPrint) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        String json = prettyPrint ? objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)report) : objectMapper.writeValueAsString((Object)report);
        String str = "window.api=" + json;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (BestCompressionGZIPOutputStream outputStream = new BestCompressionGZIPOutputStream((OutputStream)byteArrayOutputStream);){
            outputStream.write(str.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return "<script type=\"application/gzip\" class=\"ldr-js\">" + this.base85Encoder.encode(byteArrayOutputStream.toByteArray()) + "</script>";
    }
}

