/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.generator;

import java.nio.file.Path;
import java.util.Objects;
import org.molgenis.vcf.report.generator.ReportGenerator;
import org.molgenis.vcf.report.generator.ReportWriter;
import org.molgenis.vcf.report.generator.Settings;
import org.molgenis.vcf.report.model.Report;
import org.springframework.stereotype.Component;

@Component
public class ReportService {
    private final ReportGenerator reportGenerator;
    private final ReportWriter reportWriter;

    public ReportService(ReportGenerator reportGenerator, ReportWriter reportWriter) {
        this.reportGenerator = Objects.requireNonNull(reportGenerator);
        this.reportWriter = Objects.requireNonNull(reportWriter);
    }

    public void createReport(Settings settings) {
        Path inputVcfPath = settings.getInputVcfPath();
        Report report = this.reportGenerator.generateReport(inputVcfPath, settings.getSampleSettings(), settings.getReportGeneratorSettings());
        Path outputReportPath = settings.getOutputReportPath();
        this.reportWriter.write(report, outputReportPath, settings.getReportWriterSettings());
    }
}

