/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFIterator;
import htsjdk.variant.vcf.VCFIteratorBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.molgenis.vcf.report.fasta.VariantFastaSlicer;
import org.molgenis.vcf.report.fasta.VcfFastaSlicerFactory;
import org.molgenis.vcf.report.generator.ReportGeneratorSettings;
import org.molgenis.vcf.report.generator.SampleSettings;
import org.molgenis.vcf.report.genes.GenesFilter;
import org.molgenis.vcf.report.genes.GenesFilterFactory;
import org.molgenis.vcf.report.model.Binary;
import org.molgenis.vcf.report.model.Bytes;
import org.molgenis.vcf.report.model.Items;
import org.molgenis.vcf.report.model.Report;
import org.molgenis.vcf.report.model.ReportData;
import org.molgenis.vcf.report.model.metadata.AppMetadata;
import org.molgenis.vcf.report.model.metadata.ReportMetadata;
import org.molgenis.vcf.report.utils.VcfInputStreamDecorator;
import org.molgenis.vcf.utils.PersonListMerger;
import org.molgenis.vcf.utils.model.metadata.HtsFile;
import org.molgenis.vcf.utils.sample.mapper.HtsFileMapper;
import org.molgenis.vcf.utils.sample.mapper.HtsJdkToPersonsMapper;
import org.molgenis.vcf.utils.sample.mapper.PedToSamplesMapper;
import org.molgenis.vcf.utils.sample.mapper.PhenopacketMapper;
import org.molgenis.vcf.utils.sample.model.Sample;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ReportGenerator {
    private final HtsJdkToPersonsMapper htsJdkToPersonsMapper;
    private final PhenopacketMapper phenopacketMapper;
    private final PersonListMerger personListMerger;
    private final HtsFileMapper htsFileMapper;
    private final GenesFilterFactory genesFilterFactory;
    private final VcfFastaSlicerFactory vcfFastaSlicerFactory;

    public ReportGenerator(HtsJdkToPersonsMapper htsJdkToPersonsMapper, PhenopacketMapper phenopacketMapper, PersonListMerger personListMerger, HtsFileMapper htsFileMapper, VcfFastaSlicerFactory vcfFastaSlicerFactory, GenesFilterFactory genesFilterFactory) {
        this.htsJdkToPersonsMapper = Objects.requireNonNull(htsJdkToPersonsMapper);
        this.phenopacketMapper = Objects.requireNonNull(phenopacketMapper);
        this.personListMerger = Objects.requireNonNull(personListMerger);
        this.htsFileMapper = Objects.requireNonNull(htsFileMapper);
        this.genesFilterFactory = Objects.requireNonNull(genesFilterFactory);
        this.vcfFastaSlicerFactory = Objects.requireNonNull(vcfFastaSlicerFactory);
    }

    public Report generateReport(Path inputVcfPath, SampleSettings sampleSettings, ReportGeneratorSettings reportGeneratorSettings) {
        Report report;
        try (VCFIterator vcfIterator = this.createReader(inputVcfPath);){
            report = this.createReport(vcfIterator, inputVcfPath, sampleSettings, reportGeneratorSettings);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return report;
    }

    private VCFIterator createReader(Path vcfPath) throws IOException {
        return new VCFIteratorBuilder().open(VcfInputStreamDecorator.preprocessVCF((File)vcfPath.toFile()));
    }

    private Report createReport(VCFIterator vcfFileReader, Path vcfPath, SampleSettings sampleSettings, ReportGeneratorSettings reportGeneratorSettings) throws IOException {
        Map vcfMeta;
        Map sampleTree;
        Map decisionTree;
        Items phenopackets;
        HtsFile htsFile = this.htsFileMapper.map(vcfFileReader.getHeader(), vcfPath.toString());
        Items samples = this.createPersons(vcfFileReader, sampleSettings.getProbandNames(), sampleSettings.getPedigreePaths(), reportGeneratorSettings);
        String phenotypes = sampleSettings.getPhenotypeString();
        if (phenotypes != null && !phenotypes.isEmpty()) {
            List phenopacketsList = this.phenopacketMapper.mapPhenotypes(phenotypes, samples.getItems());
            phenopackets = new Items(phenopacketsList, (long)phenopacketsList.size());
        } else {
            phenopackets = new Items(Collections.emptyList(), 0L);
        }
        AppMetadata appMetadata = new AppMetadata(reportGeneratorSettings.getAppName(), reportGeneratorSettings.getAppVersion(), reportGeneratorSettings.getAppArguments());
        ReportMetadata reportMetadata = new ReportMetadata(appMetadata, htsFile);
        ReportData reportData = new ReportData(samples.getItems(), phenopackets.getItems());
        Path referencePath = reportGeneratorSettings.getReferencePath();
        Map cramPaths = sampleSettings.getCramPaths();
        Map fastaGzMap = this.getReferenceTrackData(vcfFileReader, referencePath, cramPaths);
        Bytes genesGz = this.getGenesTrackData(vcfFileReader, reportGeneratorSettings, referencePath, cramPaths);
        Map cramMap = ReportGenerator.getAlignmentTrackData((SampleSettings)sampleSettings);
        Bytes vcfBytes = ReportGenerator.getVariantTrackData((Path)vcfPath);
        Path decisionTreePath = reportGeneratorSettings.getDecisionTreePath();
        if (decisionTreePath != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                decisionTree = (Map)mapper.readValue(decisionTreePath.toFile(), Map.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            decisionTree = null;
        }
        Path sampleTreePath = reportGeneratorSettings.getSampleTreePath();
        if (sampleTreePath != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                sampleTree = (Map)mapper.readValue(sampleTreePath.toFile(), Map.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            sampleTree = null;
        }
        Path vcfMetaPath = reportGeneratorSettings.getMetadataPath();
        if (vcfMetaPath != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                vcfMeta = (Map)mapper.readValue(vcfMetaPath.toFile(), Map.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            vcfMeta = null;
        }
        Binary binary = new Binary(vcfBytes, fastaGzMap, genesGz, cramMap);
        return new Report(reportMetadata, reportData, binary, decisionTree, sampleTree, vcfMeta);
    }

    private static Bytes getVariantTrackData(Path vcfPath) throws IOException {
        Bytes vcfBytes;
        if (vcfPath.toString().endsWith(".gz")) {
            try (GZIPInputStream inputStream = new GZIPInputStream(Files.newInputStream(vcfPath, new OpenOption[0]));){
                vcfBytes = new Bytes(inputStream.readAllBytes());
            }
        } else {
            vcfBytes = new Bytes(Files.readAllBytes(vcfPath));
        }
        return vcfBytes;
    }

    private static Map<String, Binary.Cram> getAlignmentTrackData(SampleSettings sampleSettings) {
        LinkedHashMap<String, Binary.Cram> cramMap = new LinkedHashMap<String, Binary.Cram>();
        sampleSettings.getCramPaths().forEach((sampleId, cramPath) -> {
            byte[] crai;
            byte[] cram;
            try {
                cram = Files.readAllBytes(cramPath.getCram());
                crai = Files.readAllBytes(cramPath.getCrai());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            cramMap.put((String)sampleId, new Binary.Cram(new Bytes(cram), new Bytes(crai)));
        });
        return cramMap;
    }

    private Map<String, Bytes> getReferenceTrackData(VCFIterator vcfFileReader, Path referencePath, Map<String, SampleSettings.CramPath> cramPaths) {
        Map fastaGzMap;
        if (referencePath != null) {
            VariantFastaSlicer variantFastaSlicer = this.vcfFastaSlicerFactory.create(referencePath);
            fastaGzMap = variantFastaSlicer.generate(vcfFileReader, cramPaths, referencePath);
        } else {
            fastaGzMap = null;
        }
        return fastaGzMap;
    }

    private Bytes getGenesTrackData(VCFIterator vcfIterator, ReportGeneratorSettings reportGeneratorSettings, Path referencePath, Map<String, SampleSettings.CramPath> cramPaths) {
        Bytes genesGz;
        Path genesPath = reportGeneratorSettings.getGenesPath();
        if (genesPath != null) {
            GenesFilter genesFilter = this.genesFilterFactory.create(genesPath);
            genesGz = new Bytes(genesFilter.filter(vcfIterator, cramPaths, referencePath));
        } else {
            genesGz = null;
        }
        return genesGz;
    }

    private Items<Sample> createPersons(VCFIterator vcfFileReader, List<String> probandNames, List<Path> pedigreePaths, ReportGeneratorSettings settings) {
        VCFHeader fileHeader = vcfFileReader.getHeader();
        int maxNrSamples = settings.getMaxNrSamples();
        List samplesList = this.htsJdkToPersonsMapper.map(fileHeader, maxNrSamples);
        Items sampleItems = new Items(samplesList, (long)samplesList.size());
        if (pedigreePaths != null) {
            Map pedigreePersons = PedToSamplesMapper.mapPedFileToPersons(pedigreePaths, (int)maxNrSamples);
            List mergedSamples = this.personListMerger.merge(samplesList, pedigreePersons, maxNrSamples);
            sampleItems = new Items(mergedSamples, (long)mergedSamples.size());
        }
        if (!probandNames.isEmpty()) {
            sampleItems.getItems().forEach(sample -> {
                if (probandNames.contains(sample.getPerson().getIndividualId())) {
                    sample.setProband(true);
                }
            });
        } else {
            sampleItems.getItems().forEach(sample -> sample.setProband(true));
        }
        return sampleItems;
    }
}

