/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.generator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import org.molgenis.vcf.report.utils.BestCompressionGZIPOutputStream;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class BinaryEncoder {
    public byte[] encode(Path path) {
        byte[] bytes = path.toString().toLowerCase().endsWith(".gz") ? BinaryEncoder.decompress((Path)path) : BinaryEncoder.toBytes((Path)path);
        return BinaryEncoder.compress((byte[])bytes);
    }

    private static byte[] toBytes(Path gzPath) {
        try {
            return Files.readAllBytes(gzPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static byte[] decompress(Path gzPath) {
        byte[] bytes;
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(Files.newInputStream(gzPath, new OpenOption[0]));){
            bytes = gzipInputStream.readAllBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return bytes;
    }

    private static byte[] compress(byte[] bytes) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (BestCompressionGZIPOutputStream gzipOutputStream = new BestCompressionGZIPOutputStream((OutputStream)byteArrayOutputStream);){
            gzipOutputStream.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

