/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.fasta;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.molgenis.vcf.report.fasta.ContigInterval;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class VcfIntervalCalculator {
    public Map<String, List<ContigInterval>> calculate(VCFHeader vcfHeader, Iterator<VariantContext> vcfIterator, int flanking) {
        return this.calculate(vcfHeader, vcfIterator, flanking, null);
    }

    public Map<String, List<ContigInterval>> calculate(VCFHeader vcfHeader, Iterator<VariantContext> vcfIterator, int flanking, String sampleId) {
        LinkedHashMap<String, List<ContigInterval>> intervalMap = new LinkedHashMap<String, List<ContigInterval>>();
        Map contigLengthMap = this.createContigLengthMap(vcfHeader.getContigLines());
        vcfIterator.forEachRemaining(variantContext -> {
            if (VcfIntervalCalculator.includeVariantContext((String)sampleId, (VariantContext)variantContext)) {
                String contig = variantContext.getContig();
                int pos = variantContext.getStart();
                int start = Math.max(pos - flanking, 1);
                Integer contigLength = (Integer)contigLengthMap.get(contig);
                int stop = contigLength != null ? Math.min(pos + flanking, contigLength) : pos + flanking;
                ContigInterval contigInterval = new ContigInterval(contig, start, stop);
                intervalMap.computeIfAbsent(contig, k -> new ArrayList()).add(contigInterval);
            }
        });
        return intervalMap;
    }

    private Map<String, Integer> createContigLengthMap(List<VCFContigHeaderLine> contigLines) {
        HashMap<String, Integer> contigLengthMap = new HashMap<String, Integer>();
        contigLines.forEach(contigLine -> {
            String lengthStr = (String)contigLine.getGenericFields().get("length");
            if (lengthStr != null) {
                int length = Integer.parseInt(lengthStr);
                contigLengthMap.put(contigLine.getID(), length);
            }
        });
        return contigLengthMap;
    }

    private static boolean includeVariantContext(String sampleId, VariantContext variantContext) {
        return sampleId == null || variantContext.hasGenotype(sampleId) && variantContext.getGenotype(sampleId).isCalled();
    }
}

