/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.fasta;

import java.nio.file.Path;
import java.util.Objects;
import org.molgenis.vcf.report.fasta.FastaSlicer;
import org.molgenis.vcf.report.fasta.FastaSlicerFactory;
import org.molgenis.vcf.report.fasta.VariantFastaSlicer;
import org.molgenis.vcf.report.fasta.VariantIntervalCalculator;
import org.springframework.stereotype.Component;

@Component
public class VcfFastaSlicerFactory {
    private final FastaSlicerFactory fastaSlicerFactory;
    private final VariantIntervalCalculator variantIntervalCalculator;

    VcfFastaSlicerFactory(FastaSlicerFactory fastaSlicerFactory, VariantIntervalCalculator variantIntervalCalculator) {
        this.fastaSlicerFactory = Objects.requireNonNull(fastaSlicerFactory);
        this.variantIntervalCalculator = Objects.requireNonNull(variantIntervalCalculator);
    }

    public VariantFastaSlicer create(Path fastaGzPath) {
        FastaSlicer fastaSlicer = this.fastaSlicerFactory.create(fastaGzPath);
        return new VariantFastaSlicer(fastaSlicer, this.variantIntervalCalculator);
    }
}

