/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.fasta;

import htsjdk.variant.vcf.VCFIterator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.molgenis.vcf.report.fasta.ContigInterval;
import org.molgenis.vcf.report.fasta.CramIntervalCalculator;
import org.molgenis.vcf.report.fasta.VcfIntervalCalculator;
import org.molgenis.vcf.report.generator.SampleSettings;
import org.molgenis.vcf.report.utils.IntervalUtils;
import org.springframework.stereotype.Component;

@Component
public class VariantIntervalCalculator {
    public static final int FLANKING = 250;
    private final VcfIntervalCalculator vcfIntervalCalculator;
    private final CramIntervalCalculator cramIntervalCalculator;

    public VariantIntervalCalculator(VcfIntervalCalculator vcfIntervalCalculator, CramIntervalCalculator cramIntervalCalculator) {
        this.vcfIntervalCalculator = Objects.requireNonNull(vcfIntervalCalculator);
        this.cramIntervalCalculator = Objects.requireNonNull(cramIntervalCalculator);
    }

    public List<ContigInterval> calculate(VCFIterator vcfIterator, Map<String, SampleSettings.CramPath> cramPaths, Path referencePath) {
        List<Object> intervals = new ArrayList<ContigInterval>();
        if (cramPaths != null && !cramPaths.isEmpty()) {
            Map vcfIntervals = this.vcfIntervalCalculator.calculate(vcfIterator.getHeader(), (Iterator)vcfIterator, 250, null);
            Map cramIntervals = this.cramIntervalCalculator.calculate(cramPaths, referencePath);
            intervals = this.mergeIntervalLists(cramIntervals, vcfIntervals);
        } else {
            Map intervalMap = this.vcfIntervalCalculator.calculate(vcfIterator.getHeader(), (Iterator)vcfIterator, 250, null);
            for (Map.Entry entry : intervalMap.entrySet()) {
                intervals.addAll(IntervalUtils.mergeIntervals((List)((List)entry.getValue())));
            }
        }
        return intervals;
    }

    private List<ContigInterval> mergeIntervalLists(Map<String, List<ContigInterval>> cramIntervalMap, Map<String, List<ContigInterval>> vcfIntervalMap) {
        ArrayList<ContigInterval> intervals = new ArrayList<ContigInterval>();
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(cramIntervalMap.keySet());
        keys.addAll(vcfIntervalMap.keySet());
        for (String key : keys) {
            List vcfIntervals = vcfIntervalMap.containsKey(key) ? vcfIntervalMap.get(key) : Collections.emptyList();
            List cramIntervals = cramIntervalMap.containsKey(key) ? cramIntervalMap.get(key) : Collections.emptyList();
            ArrayList combinedIntervals = new ArrayList();
            combinedIntervals.addAll(vcfIntervals);
            combinedIntervals.addAll(cramIntervals);
            intervals.addAll(IntervalUtils.mergeIntervals(combinedIntervals));
        }
        return intervals;
    }
}

