/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.fasta;

import htsjdk.variant.vcf.VCFIterator;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.molgenis.vcf.report.fasta.ContigInterval;
import org.molgenis.vcf.report.fasta.FastaSlice;
import org.molgenis.vcf.report.fasta.FastaSlicer;
import org.molgenis.vcf.report.fasta.VariantIntervalCalculator;
import org.molgenis.vcf.report.generator.SampleSettings;
import org.molgenis.vcf.report.model.Bytes;

/*
 * Exception performing whole class analysis ignored.
 */
public class VariantFastaSlicer {
    private final FastaSlicer fastaSlicer;
    private final VariantIntervalCalculator variantIntervalCalculator;

    public VariantFastaSlicer(FastaSlicer fastaSlicer, VariantIntervalCalculator variantIntervalCalculator) {
        this.fastaSlicer = Objects.requireNonNull(fastaSlicer);
        this.variantIntervalCalculator = variantIntervalCalculator;
    }

    public Map<String, Bytes> generate(VCFIterator vcfIterator, Map<String, SampleSettings.CramPath> cramPaths, Path referencePath) {
        LinkedHashMap fastaGzMap;
        if (referencePath != null) {
            List intervals = this.variantIntervalCalculator.calculate(vcfIterator, cramPaths, referencePath);
            List<FastaSlice> fastaGzSlices = intervals.stream().map(arg_0 -> ((FastaSlicer)this.fastaSlicer).slice(arg_0)).collect(Collectors.toList());
            fastaGzMap = new LinkedHashMap();
            fastaGzSlices.forEach(fastaSlice -> {
                String key = VariantFastaSlicer.getFastaSliceIdentifier((FastaSlice)fastaSlice);
                fastaGzMap.put(key, new Bytes(fastaSlice.getFastaGz()));
            });
        } else {
            fastaGzMap = null;
        }
        return fastaGzMap;
    }

    private static String getFastaSliceIdentifier(FastaSlice fastaSlice) {
        ContigInterval interval = fastaSlice.getInterval();
        return interval.getContig() + ":" + interval.getStart() + "-" + interval.getStop();
    }
}

