/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.fasta;

import htsjdk.samtools.reference.BlockCompressedIndexedFastaSequenceFile;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.GZIIndex;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.molgenis.vcf.report.fasta.FastaSlicer;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class FastaSlicerFactory {
    public FastaSlicer create(Path fastaPath) {
        Path fastaFaiPath = Path.of(fastaPath.toString() + ".fai", new String[0]);
        Path fastaGziPath = Path.of(fastaPath.toString() + ".gzi", new String[0]);
        FastaSequenceIndex fastaSequenceIndex = new FastaSequenceIndex(fastaFaiPath);
        GZIIndex gziIndex = FastaSlicerFactory.createGziIndex((Path)fastaGziPath);
        return new FastaSlicer((ReferenceSequenceFile)FastaSlicerFactory.createReferenceSequenceFile((Path)fastaPath, (FastaSequenceIndex)fastaSequenceIndex, (GZIIndex)gziIndex));
    }

    private static BlockCompressedIndexedFastaSequenceFile createReferenceSequenceFile(Path fastaPath, FastaSequenceIndex fastaSequenceIndex, GZIIndex gziIndex) {
        return new BlockCompressedIndexedFastaSequenceFile(fastaPath, fastaSequenceIndex, gziIndex);
    }

    private static GZIIndex createGziIndex(Path fastaGziPath) {
        GZIIndex gziIndex;
        try (SeekableByteChannel byteChannel = Files.newByteChannel(fastaGziPath, new OpenOption[0]);){
            gziIndex = GZIIndex.loadIndex(null, (ReadableByteChannel)byteChannel);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return gziIndex;
    }
}

