/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.fasta;

import htsjdk.samtools.reference.FastaReferenceWriter;
import htsjdk.samtools.reference.FastaReferenceWriterBuilder;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.molgenis.vcf.report.fasta.ContigInterval;
import org.molgenis.vcf.report.fasta.FastaSlice;
import org.molgenis.vcf.report.utils.BestCompressionGZIPOutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class FastaSlicer {
    private final ReferenceSequenceFile referenceSequenceFile;

    public FastaSlicer(ReferenceSequenceFile referenceSequenceFile) {
        this.referenceSequenceFile = Objects.requireNonNull(referenceSequenceFile);
    }

    public FastaSlice slice(ContigInterval interval) {
        byte[] fasta = this.createFasta(interval);
        byte[] fastaGz = BestCompressionGZIPOutputStream.compress((byte[])fasta);
        return new FastaSlice(interval, fastaGz);
    }

    private byte[] createFasta(ContigInterval interval) {
        ReferenceSequence referenceSequence = this.referenceSequenceFile.getSubsequenceAt(interval.getContig(), (long)interval.getStart(), (long)interval.getStop());
        String referenceSequenceName = interval.getContig() + ":" + interval.getStart() + "-" + interval.getStop();
        ReferenceSequence renamedReferenceSequence = new ReferenceSequence(referenceSequenceName, referenceSequence.getContigIndex(), referenceSequence.getBases());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (FastaReferenceWriter fastaReferenceWriter = FastaSlicer.createFastaReferenceWriter((OutputStream)outputStream);){
            fastaReferenceWriter.addSequence(renamedReferenceSequence);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return outputStream.toByteArray();
    }

    private static FastaReferenceWriter createFastaReferenceWriter(OutputStream outputStream) throws IOException {
        return new FastaReferenceWriterBuilder().setFastaOutput(outputStream).setBasesPerLine(Integer.MAX_VALUE).setEmitMd5(false).setMakeFaiOutput(false).setMakeDictOutput(false).setMakeGziOutput(false).build();
    }
}

