/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report.fasta;

import htsjdk.samtools.CRAMFileReader;
import htsjdk.samtools.SAMRecordIterator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.molgenis.vcf.report.fasta.ContigInterval;
import org.molgenis.vcf.report.fasta.CramReaderFactory;
import org.molgenis.vcf.report.generator.SampleSettings;
import org.springframework.stereotype.Component;

@Component
public class CramIntervalCalculator {
    private final CramReaderFactory cramReaderFactory;

    public CramIntervalCalculator(CramReaderFactory cramReaderFactory) {
        this.cramReaderFactory = Objects.requireNonNull(cramReaderFactory);
    }

    public Map<String, List<ContigInterval>> calculate(Map<String, SampleSettings.CramPath> crampaths, Path reference) {
        LinkedHashMap<String, List<ContigInterval>> intervalMap = new LinkedHashMap<String, List<ContigInterval>>();
        for (SampleSettings.CramPath cramPath : crampaths.values()) {
            CRAMFileReader reader = this.cramReaderFactory.create(cramPath, reference);
            try {
                SAMRecordIterator iterator = reader.getIterator();
                iterator.stream().forEach(cramRecord -> {
                    ContigInterval contigInterval = new ContigInterval(cramRecord.getContig(), cramRecord.getStart(), cramRecord.getEnd());
                    intervalMap.computeIfAbsent(cramRecord.getContig(), k -> new ArrayList()).add(contigInterval);
                });
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        return intervalMap;
    }
}

