/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.molgenis.vcf.report.generator.ReportGeneratorSettings;
import org.molgenis.vcf.report.generator.ReportWriterSettings;
import org.molgenis.vcf.report.generator.SampleSettings;
import org.molgenis.vcf.report.generator.Settings;
import org.molgenis.vcf.report.utils.PathUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AppCommandLineToSettingsMapper {
    private final String appName;
    private final String appVersion;

    AppCommandLineToSettingsMapper(@Value(value="${app.name}") String appName, @Value(value="${app.version}") String appVersion) {
        this.appName = appName;
        this.appVersion = appVersion;
    }

    Settings map(CommandLine commandLine, String ... args) {
        Map cramPaths;
        Path sampleTreePath;
        Path decisionTreePath;
        Path genesPath;
        Path referencePath;
        Path metadataPath;
        String inputPathValue = commandLine.getOptionValue("i");
        Path inputPath = Path.of(inputPathValue, new String[0]);
        String templateValue = commandLine.getOptionValue("t");
        Path templatePath = Path.of(templateValue, new String[0]);
        if (commandLine.hasOption("m")) {
            String metadataPathValue = commandLine.getOptionValue("m");
            metadataPath = Path.of(metadataPathValue, new String[0]);
        } else {
            metadataPath = null;
        }
        Path outputPath = commandLine.hasOption("o") ? Path.of(commandLine.getOptionValue("o"), new String[0]) : Path.of(commandLine.getOptionValue("i") + ".html", new String[0]);
        List<Object> probandNames = commandLine.hasOption("pb") ? Arrays.asList(commandLine.getOptionValue("pb").split(",")) : List.of();
        List pedPaths = commandLine.hasOption("pd") ? PathUtils.parsePaths((String)commandLine.getOptionValue("pd")) : null;
        String phenotypes = commandLine.hasOption("ph") ? commandLine.getOptionValue("ph") : null;
        int maxSamples = commandLine.hasOption("ms") ? Integer.parseInt(commandLine.getOptionValue("ms")) : 100;
        if (commandLine.hasOption("r")) {
            String referencePathValue = commandLine.getOptionValue("r");
            referencePath = Path.of(referencePathValue, new String[0]);
        } else {
            referencePath = null;
        }
        if (commandLine.hasOption("g")) {
            String genesPathValue = commandLine.getOptionValue("g");
            genesPath = Path.of(genesPathValue, new String[0]);
        } else {
            genesPath = null;
        }
        if (commandLine.hasOption("dt")) {
            String decisionTreePathValue = commandLine.getOptionValue("dt");
            decisionTreePath = Path.of(decisionTreePathValue, new String[0]);
        } else {
            decisionTreePath = null;
        }
        if (commandLine.hasOption("st")) {
            String sampleTreePathValue = commandLine.getOptionValue("st");
            sampleTreePath = Path.of(sampleTreePathValue, new String[0]);
        } else {
            sampleTreePath = null;
        }
        if (commandLine.hasOption("c")) {
            String cramPathValue = commandLine.getOptionValue("c");
            cramPaths = this.toCramPaths(cramPathValue);
        } else {
            cramPaths = Map.of();
        }
        boolean overwriteOutput = commandLine.hasOption("f");
        boolean debugMode = commandLine.hasOption("d");
        String appArgs = String.join((CharSequence)" ", args);
        ReportGeneratorSettings reportGeneratorSettings = new ReportGeneratorSettings(this.appName, this.appVersion, appArgs, maxSamples, metadataPath, referencePath, genesPath, decisionTreePath, sampleTreePath);
        ReportWriterSettings reportWriterSettings = new ReportWriterSettings(templatePath, debugMode);
        SampleSettings sampleSettings = new SampleSettings(probandNames, pedPaths, phenotypes, cramPaths);
        return new Settings(inputPath, reportGeneratorSettings, outputPath, overwriteOutput, reportWriterSettings, sampleSettings);
    }

    private Map<String, SampleSettings.CramPath> toCramPaths(String cramPathValue) {
        String[] tokens;
        LinkedHashMap<String, SampleSettings.CramPath> cramPaths = new LinkedHashMap<String, SampleSettings.CramPath>();
        for (String token : tokens = cramPathValue.split(",")) {
            int idx = token.indexOf("=");
            String sampleId = token.substring(0, idx);
            String cramStr = token.substring(idx + 1);
            Path cramPath = Path.of(cramStr, new String[0]);
            Path craiPath = Path.of(cramStr + ".crai", new String[0]);
            cramPaths.put(sampleId, new SampleSettings.CramPath(cramPath, craiPath));
        }
        return cramPaths;
    }
}

