/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report;

import ch.qos.logback.classic.Level;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.molgenis.vcf.report.AppCommandLineOptions;
import org.molgenis.vcf.report.AppCommandLineToSettingsMapper;
import org.molgenis.vcf.report.generator.ReportService;
import org.molgenis.vcf.report.generator.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class AppCommandLineRunner
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppCommandLineRunner.class);
    private static final int STATUS_MISC_ERROR = 1;
    private static final int STATUS_COMMAND_LINE_USAGE_ERROR = 64;
    private final String appName;
    private final String appVersion;
    private final AppCommandLineToSettingsMapper appCommandLineToSettingsMapper;
    private final ReportService reportService;
    private final CommandLineParser commandLineParser;

    AppCommandLineRunner(@Value(value="${app.name}") String appName, @Value(value="${app.version}") String appVersion, AppCommandLineToSettingsMapper appCommandLineToSettingsMapper, ReportService reportService) {
        this.appName = Objects.requireNonNull(appName);
        this.appVersion = Objects.requireNonNull(appVersion);
        this.appCommandLineToSettingsMapper = Objects.requireNonNull(appCommandLineToSettingsMapper);
        this.reportService = Objects.requireNonNull(reportService);
        this.commandLineParser = new DefaultParser();
    }

    public void run(String ... args) {
        if (args.length == 1 && (args[0].equals("-v") || args[0].equals("--version"))) {
            LOGGER.info("{} {}", (Object)this.appName, (Object)this.appVersion);
            return;
        }
        for (String arg : args) {
            if (!arg.equals("-d") && !arg.equals("-debug")) continue;
            Logger rootLogger = LoggerFactory.getLogger((String)"ROOT");
            if (!(rootLogger instanceof ch.qos.logback.classic.Logger)) {
                throw new ClassCastException("Expected root logger to be a logback logger");
            }
            ((ch.qos.logback.classic.Logger)rootLogger).setLevel(Level.DEBUG);
            break;
        }
        try {
            Settings settings = this.createSettings(args);
            @NonNull Path outputReportPath = settings.getOutputReportPath();
            if (settings.isOverwriteOutputReport()) {
                Files.deleteIfExists(outputReportPath);
            } else if (Files.exists(outputReportPath, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("cannot create report '%s' because it already exists, use -%s or --%s to overwrite existing file", outputReportPath, "f", "force"));
            }
            LOGGER.info("creating report for '{}' ...", (Object)settings.getInputVcfPath());
            this.reportService.createReport(settings);
            LOGGER.info("created report '{}'", (Object)outputReportPath);
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage());
            System.exit(1);
        }
    }

    private Settings createSettings(String ... args) {
        CommandLine commandLine = null;
        try {
            commandLine = this.commandLineParser.parse(AppCommandLineOptions.getAppOptions(), args);
        }
        catch (ParseException e) {
            this.logException(e);
            System.exit(64);
        }
        AppCommandLineOptions.validateCommandLine((CommandLine)commandLine);
        return this.appCommandLineToSettingsMapper.map(commandLine, args);
    }

    private void logException(ParseException e) {
        LOGGER.error(e.getLocalizedMessage());
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(null);
        String cmdLineSyntax = "java -jar " + this.appName + ".jar";
        formatter.printHelp(cmdLineSyntax, AppCommandLineOptions.getAppOptions(), true);
        System.out.println();
        formatter.printHelp(cmdLineSyntax, AppCommandLineOptions.getAppVersionOptions(), true);
    }
}

