/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.report;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.molgenis.vcf.report.InvalidIntegerException;
import org.molgenis.vcf.report.utils.InvalidSampleCramException;
import org.molgenis.vcf.report.utils.PathUtils;
import org.molgenis.vcf.utils.InvalidSamplePhenotypesException;
import org.molgenis.vcf.utils.MixedPhenotypesException;
import org.molgenis.vcf.utils.sample.mapper.PhenopacketMapper;

/*
 * Exception performing whole class analysis ignored.
 */
class AppCommandLineOptions {
    static final String OPT_INPUT = "i";
    static final String OPT_INPUT_LONG = "input";
    static final String OPT_METADATA = "m";
    static final String OPT_METADATA_LONG = "metadata";
    static final String OPT_OUTPUT = "o";
    static final String OPT_OUTPUT_LONG = "output";
    static final String OPT_TEMPLATE = "t";
    static final String OPT_TEMPLATE_LONG = "template";
    static final String OPT_PROBANDS = "pb";
    static final String OPT_PROBANDS_LONG = "probands";
    static final String OPT_PED = "pd";
    static final String OPT_PED_LONG = "pedigree";
    static final String OPT_PHENOTYPES = "ph";
    static final String OPT_PHENOTYPES_LONG = "phenotypes";
    static final String OPT_MAX_SAMPLES = "ms";
    static final String OPT_MAX_SAMPLES_LONG = "max_samples";
    static final String OPT_REFERENCE = "r";
    static final String OPT_REFERENCE_LONG = "reference";
    static final String OPT_FORCE = "f";
    static final String OPT_FORCE_LONG = "force";
    static final String OPT_DEBUG = "d";
    static final String OPT_DEBUG_LONG = "debug";
    static final String OPT_VERSION = "v";
    static final String OPT_VERSION_LONG = "version";
    static final String OPT_GENES = "g";
    static final String OPT_GENES_LONG = "genes";
    static final String OPT_TREE = "dt";
    static final String OPT_TREE_LONG = "decision_tree";
    static final String OPT_SAMPLE_TREE = "st";
    static final String OPT_SAMPLE_TREE_LONG = "sample_tree";
    static final String OPT_CRAM = "c";
    static final String OPT_CRAM_LONG = "cram";
    private static final Options APP_OPTIONS;
    private static final Options APP_VERSION_OPTIONS;

    private AppCommandLineOptions() {
    }

    static Options getAppOptions() {
        return APP_OPTIONS;
    }

    static Options getAppVersionOptions() {
        return APP_VERSION_OPTIONS;
    }

    static void validateCommandLine(CommandLine commandLine) {
        AppCommandLineOptions.validateInput((CommandLine)commandLine);
        AppCommandLineOptions.validateOutput((CommandLine)commandLine);
        AppCommandLineOptions.validateTemplate((CommandLine)commandLine);
        AppCommandLineOptions.validateProbands((CommandLine)commandLine);
        AppCommandLineOptions.validatePed((CommandLine)commandLine);
        AppCommandLineOptions.validatePhenotypes((CommandLine)commandLine);
        AppCommandLineOptions.validateMaxSamples((CommandLine)commandLine);
        AppCommandLineOptions.validateReference((CommandLine)commandLine);
        AppCommandLineOptions.validateGenes((CommandLine)commandLine);
        AppCommandLineOptions.validateCram((CommandLine)commandLine);
        AppCommandLineOptions.validateTree((CommandLine)commandLine);
    }

    static void validateReference(CommandLine commandLine) {
        if (!commandLine.hasOption("r")) {
            return;
        }
        String optionValue = commandLine.getOptionValue("r");
        Path referencePath = Path.of(optionValue, new String[0]);
        AppCommandLineOptions.validateFilePath((Path)referencePath, (String)"Reference");
        String referencePathStr = referencePath.toString();
        if (!(referencePathStr.endsWith(".fasta.gz") || referencePathStr.endsWith(".fna.gz") || referencePathStr.endsWith(".fa.gz") || referencePathStr.endsWith(".fnn.gz") || referencePathStr.endsWith(".faa.gz") || referencePathStr.endsWith(".frn.gz"))) {
            throw new IllegalArgumentException(String.format("Input file '%s' is not a .fasta.gz, .fna.gz, .fa.gz, .fnn.gz, .faa.gz or .frn.gz file.", referencePathStr));
        }
        Path referenceIndexPath = Path.of(optionValue + ".fai", new String[0]);
        AppCommandLineOptions.validateFilePath((Path)referenceIndexPath, (String)"Reference .fai");
        Path referenceGzipIndexPath = Path.of(optionValue + ".gzi", new String[0]);
        AppCommandLineOptions.validateFilePath((Path)referenceGzipIndexPath, (String)"Reference .gzi");
    }

    static void validateGenes(CommandLine commandLine) {
        if (!commandLine.hasOption("g")) {
            return;
        }
        String optionValue = commandLine.getOptionValue("g");
        Path genesPath = Path.of(optionValue, new String[0]);
        AppCommandLineOptions.validateFilePath((Path)genesPath, (String)"Genes");
        String genesPathStr = genesPath.toString();
        if (!genesPathStr.endsWith(".gff.gz") && !genesPathStr.endsWith(".gff3.gz")) {
            throw new IllegalArgumentException(String.format("Input file '%s' is not a .gff.gz or gff3.gz", genesPathStr));
        }
    }

    private static void validateCram(CommandLine commandLine) {
        if (!commandLine.hasOption("c")) {
            return;
        }
        String cramString = commandLine.getOptionValue("c");
        for (String sampleCramString : cramString.split(",")) {
            String[] tokens = sampleCramString.split("=");
            if (tokens.length != 2) {
                throw new InvalidSampleCramException(sampleCramString);
            }
            String cramPathStr = tokens[1];
            if (!cramPathStr.endsWith(".cram")) {
                throw new IllegalArgumentException(String.format("Input file '%s' is not a .cram file.", cramPathStr));
            }
            AppCommandLineOptions.validateFilePath((Path)Path.of(cramPathStr, new String[0]), (String)"cram");
            Path cramIndexPath = Path.of(cramPathStr + ".crai", new String[0]);
            AppCommandLineOptions.validateFilePath((Path)cramIndexPath, (String)"cram .crai");
        }
    }

    private static void validateMaxSamples(CommandLine commandLine) {
        AppCommandLineOptions.validateInteger((CommandLine)commandLine, (String)"ms");
    }

    private static void validateInteger(CommandLine commandLine, String option) {
        if (!commandLine.hasOption(option)) {
            return;
        }
        String maxSamplesString = commandLine.getOptionValue(option);
        try {
            int value = Integer.parseInt(maxSamplesString);
            if (value < 0) {
                throw new InvalidIntegerException(option, maxSamplesString);
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidIntegerException(option, maxSamplesString);
        }
    }

    private static void validatePhenotypes(CommandLine commandLine) {
        if (!commandLine.hasOption("ph")) {
            return;
        }
        String phenotypesString = commandLine.getOptionValue("ph");
        if (phenotypesString.contains("/")) {
            for (String samplePhenotypes : phenotypesString.split(",")) {
                if (samplePhenotypes.contains("/")) {
                    if (samplePhenotypes.split("/").length == 2) continue;
                    throw new InvalidSamplePhenotypesException(samplePhenotypes);
                }
                throw new MixedPhenotypesException();
            }
        } else {
            String[] phenotypes;
            for (String phenotype : phenotypes = phenotypesString.split(";")) {
                PhenopacketMapper.checkPhenotype((String)phenotype);
            }
        }
    }

    private static void validateInput(CommandLine commandLine) {
        Path inputPath = Path.of(commandLine.getOptionValue("i"), new String[0]);
        AppCommandLineOptions.validateFilePath((Path)inputPath, (String)"Input");
        String inputPathStr = inputPath.toString();
        if (!inputPathStr.endsWith(".vcf") && !inputPathStr.endsWith(".vcf.gz")) {
            throw new IllegalArgumentException(String.format("Input file '%s' is not a .vcf or .vcf.gz file.", inputPathStr));
        }
    }

    private static void validateOutput(CommandLine commandLine) {
        if (!commandLine.hasOption("o")) {
            return;
        }
        Path outputPath = Path.of(commandLine.getOptionValue("o"), new String[0]);
        String outputPathStr = outputPath.toString();
        if (!outputPathStr.endsWith(".html")) {
            throw new IllegalArgumentException(String.format("Output file '%s' is not a .html file.", outputPathStr));
        }
        if (!commandLine.hasOption("f") && Files.exists(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Output file '%s' already exists", outputPath.toString()));
        }
    }

    private static void validateTemplate(CommandLine commandLine) {
        Path templatePath = Path.of(commandLine.getOptionValue("t"), new String[0]);
        AppCommandLineOptions.validateFilePath((Path)templatePath, (String)"Template");
        String templatePathStr = templatePath.toString();
        if (!templatePathStr.endsWith(".html")) {
            throw new IllegalArgumentException(String.format("Template file '%s' is not a .html file.", templatePathStr));
        }
    }

    private static void validateProbands(CommandLine commandLine) {
    }

    private static void validatePed(CommandLine commandLine) {
        if (!commandLine.hasOption("pd")) {
            return;
        }
        List pedPaths = PathUtils.parsePaths((String)commandLine.getOptionValue("pd"));
        for (Path pedPath : pedPaths) {
            AppCommandLineOptions.validateFilePath((Path)pedPath, (String)"Ped");
            String templatePathStr = pedPath.toString();
            if (templatePathStr.endsWith(".ped")) continue;
            throw new IllegalArgumentException(String.format("Ped file '%s' is not a .ped file.", templatePathStr));
        }
    }

    private static void validateTree(CommandLine commandLine) {
        if (!commandLine.hasOption("dt")) {
            return;
        }
        Path treePath = Path.of(commandLine.getOptionValue("dt"), new String[0]);
        AppCommandLineOptions.validateFilePath((Path)treePath, (String)"Decision tree");
        String treePathStr = treePath.toString();
        if (!treePathStr.endsWith(".json")) {
            throw new IllegalArgumentException(String.format("Decision tree file '%s' is not a .json file.", treePathStr));
        }
    }

    private static void validateFilePath(Path filePath, String prefix) {
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s file '%s' does not exist.", prefix, filePath.toString()));
        }
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s file '%s' is a directory.", prefix, filePath.toString()));
        }
        if (!Files.isReadable(filePath)) {
            throw new IllegalArgumentException(String.format("%s file '%s' is not readable.", prefix, filePath.toString()));
        }
    }

    static {
        Options appOptions = new Options();
        appOptions.addOption(Option.builder((String)"i").hasArg(true).required().longOpt("input").desc("Input VCF file (.vcf or .vcf.gz).").build());
        appOptions.addOption(Option.builder((String)"m").hasArg(true).longOpt("metadata").desc("VCF metadata file (.json).").required().build());
        appOptions.addOption(Option.builder((String)"o").hasArg(true).longOpt("output").desc("Output report file (.html).").build());
        appOptions.addOption(Option.builder((String)"f").longOpt("force").desc("Override the output file if it already exists.").build());
        appOptions.addOption(Option.builder((String)"t").hasArg(true).longOpt("template").desc("Report template file (.html).").required().build());
        appOptions.addOption(Option.builder((String)"pb").hasArg(true).longOpt("probands").desc("Comma-separated list of proband names.").build());
        appOptions.addOption(Option.builder((String)"pd").hasArg(true).longOpt("pedigree").desc("Comma-separated list of pedigree files (.ped).").build());
        appOptions.addOption(Option.builder((String)"ph").hasArg(true).longOpt("phenotypes").desc("Comma-separated list of sample-phenotypes (e.g. HP:123 or HP:123;HP:234 or sample0/HP:123,sample1/HP:234). Phenotypes are CURIE formatted (prefix:reference) and separated by a semicolon.").build());
        appOptions.addOption(Option.builder((String)"ms").hasArg(true).longOpt("max_samples").desc(String.format("Integer stating the maximum number of samples to be available in the report. Default: %s", 100)).build());
        appOptions.addOption(Option.builder((String)"r").hasArg(true).longOpt("reference").desc("Reference sequence file (.fasta.gz, .fna.gz, .fa.gz, .ffn.gz, .faa.gz or .frn.gz).").build());
        appOptions.addOption(Option.builder((String)"g").hasArg(true).longOpt("genes").desc("Genes file to be used as reference track in the genome browser, UCSC NCBI RefSeq GFF file (gff.gz or gff3.gz).").build());
        appOptions.addOption(Option.builder((String)"c").hasArg(true).longOpt("cram").desc("Comma-separated list of sample-cram files (e.g. sample0=/path/to/0.cram,sample1=/path/to/1.cram).").build());
        appOptions.addOption(Option.builder((String)"dt").hasArg(true).longOpt("decision_tree").desc("Decision tree file as used in vip-decision-tree (.json).").build());
        appOptions.addOption(Option.builder((String)"st").hasArg(true).longOpt("sample_tree").desc("Sample decision tree file as used in vip-decision-tree (.json).").build());
        appOptions.addOption(Option.builder((String)"d").longOpt("debug").desc("Enable debug mode (additional logging and pretty printed report).").build());
        APP_OPTIONS = appOptions;
        Options appVersionOptions = new Options();
        appVersionOptions.addOption(Option.builder((String)"v").required().longOpt("version").desc("Print version.").build());
        APP_VERSION_OPTIONS = appVersionOptions;
    }
}

