/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.utils;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.molgenis.vcf.decisiontree.filter.UnsupportedFieldException;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.molgenis.vcf.decisiontree.utils.TypeConversionException;
import org.molgenis.vcf.decisiontree.utils.VcfUtils;
import org.molgenis.vcf.utils.UnexpectedEnumException;
import org.springframework.lang.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class VcfUtils {
    public static final String FIELD_TOKEN_SEPARATOR = "/";

    private VcfUtils() {
    }

    public static Integer getInfoAsInteger(VariantContext variantContext, Field field) {
        Object value = variantContext.getAttribute(field.getId());
        return VcfUtils.getVcfValueAsInteger((Object)value);
    }

    public static List<Integer> getInfoAsIntegerList(VariantContext variantContext, Field field) {
        List<Integer> integerValues;
        Object value = variantContext.getAttribute(field.getId());
        if (value == null) {
            integerValues = List.of();
        } else if (value instanceof List) {
            List objectValues = (List)value;
            int size = objectValues.size();
            if (size == 0) {
                integerValues = Collections.emptyList();
            } else if (size == 1) {
                integerValues = Collections.singletonList(VcfUtils.getVcfValueAsInteger(objectValues.get(0)));
            } else {
                integerValues = new ArrayList<Integer>(objectValues.size());
                for (Object objValue : objectValues) {
                    integerValues.add(VcfUtils.getVcfValueAsInteger(objValue));
                }
            }
        } else if (value instanceof String) {
            String stringValue = (String)value;
            integerValues = Collections.singletonList(VcfUtils.getInfoStringValueAsInteger((String)stringValue));
        } else {
            throw new TypeConversionException(value, Integer.class);
        }
        return integerValues;
    }

    @Nullable
    private static Integer getVcfValueAsInteger(@Nullable Object objValue) {
        Integer intValue;
        if (objValue == null) {
            intValue = null;
        } else if (objValue instanceof Integer) {
            Integer integer;
            intValue = integer = (Integer)objValue;
        } else if (objValue instanceof String) {
            String stringValue = (String)objValue;
            intValue = VcfUtils.getInfoStringValueAsInteger((String)stringValue);
        } else {
            throw new TypeConversionException(objValue, Integer.class);
        }
        return intValue;
    }

    @Nullable
    private static Integer getInfoStringValueAsInteger(String infoStrValue) {
        Integer intValue = infoStrValue.equals(".") ? null : Integer.valueOf(infoStrValue);
        return intValue;
    }

    public static Double getInfoAsDouble(VariantContext variantContext, Field field) {
        Object value = variantContext.getAttribute(field.getId());
        return VcfUtils.getVcfValueAsDouble((Object)value);
    }

    public static List<Double> getInfoAsDoubleList(VariantContext variantContext, Field field) {
        List<Double> doubleValues;
        Object value = variantContext.getAttribute(field.getId());
        if (value == null) {
            doubleValues = List.of();
        } else if (value instanceof List) {
            List objectValues = (List)value;
            int size = objectValues.size();
            if (size == 0) {
                doubleValues = Collections.emptyList();
            } else if (size == 1) {
                doubleValues = Collections.singletonList(VcfUtils.getVcfValueAsDouble(objectValues.get(0)));
            } else {
                doubleValues = new ArrayList<Double>(objectValues.size());
                for (Object objValue : objectValues) {
                    doubleValues.add(VcfUtils.getVcfValueAsDouble(objValue));
                }
            }
        } else if (value instanceof String) {
            String string = (String)value;
            doubleValues = Collections.singletonList(VcfUtils.getInfoStringValueAsDouble((String)string));
        } else {
            throw new TypeConversionException(value, Double.class);
        }
        return doubleValues;
    }

    @Nullable
    private static Double getVcfValueAsDouble(@Nullable Object objValue) {
        Double doubleValue;
        if (objValue == null) {
            doubleValue = null;
        } else if (objValue instanceof Double) {
            Double doubleVal;
            doubleValue = doubleVal = (Double)objValue;
        } else if (objValue instanceof String) {
            String string = (String)objValue;
            doubleValue = VcfUtils.getInfoStringValueAsDouble((String)string);
        } else {
            throw new TypeConversionException(objValue, Double.class);
        }
        return doubleValue;
    }

    @Nullable
    private static Double getInfoStringValueAsDouble(String infoStrValue) {
        Double doubleValue = infoStrValue.equals(".") ? null : Double.valueOf(infoStrValue);
        return doubleValue;
    }

    public static String getInfoAsString(VariantContext variantContext, Field field) {
        Object value = variantContext.getAttribute(field.getId());
        return VcfUtils.getVcfValueAsString((Object)value);
    }

    public static List<String> getInfoAsStringList(VariantContext variantContext, Field field) {
        String id = field.getId();
        List strValues = VcfUtils.getInfoAsStringList((VariantContext)variantContext, (String)id);
        return strValues;
    }

    public static List<String> getInfoAsStringList(VariantContext variantContext, String id) {
        List<String> strValues;
        Object value = variantContext.getAttribute(id);
        if (value == null) {
            strValues = List.of();
        } else if (value instanceof List) {
            List objectValues = (List)value;
            int size = objectValues.size();
            if (size == 0) {
                strValues = Collections.emptyList();
            } else if (size == 1) {
                strValues = Collections.singletonList(VcfUtils.getVcfValueAsString(objectValues.get(0)));
            } else {
                strValues = new ArrayList<String>(objectValues.size());
                for (Object objValue : objectValues) {
                    strValues.add(VcfUtils.getVcfValueAsString(objValue));
                }
            }
        } else if (value instanceof String) {
            String string = (String)value;
            strValues = Collections.singletonList(VcfUtils.getInfoStringValueAsString((String)string));
        } else {
            throw new TypeConversionException(value, String.class);
        }
        return strValues;
    }

    @Nullable
    private static String getVcfValueAsString(@Nullable Object objValue) {
        String strValue;
        if (objValue == null) {
            strValue = null;
        } else if (objValue instanceof String) {
            String string = (String)objValue;
            strValue = VcfUtils.getInfoStringValueAsString((String)string);
        } else {
            throw new TypeConversionException(objValue, String.class);
        }
        return strValue;
    }

    @Nullable
    private static String getInfoStringValueAsString(String infoStrValue) {
        String stringValue = infoStrValue.equals(".") ? null : infoStrValue;
        return stringValue;
    }

    public static boolean getInfoAsBoolean(VariantContext variantContext, Field field) {
        Object objValue = variantContext.getAttribute(field.getId());
        return VcfUtils.getVcfValueAsBoolean((Object)objValue);
    }

    private static boolean getVcfValueAsBoolean(Object objValue) {
        boolean bool;
        if (objValue == null) {
            bool = false;
        } else if (objValue instanceof Boolean) {
            Boolean boolVal = (Boolean)objValue;
            bool = boolVal;
        } else {
            throw new TypeConversionException(objValue, Boolean.class);
        }
        return bool;
    }

    public static Object getTypedVcfValue(Field field, String stringValue, String separator) {
        List<Object> value;
        if (separator == null) {
            value = VcfUtils.getTypedVcfValue((Field)field, (String)stringValue);
        } else {
            List<String> values = Arrays.asList(stringValue.split(separator));
            value = values.stream().map(singleValue -> VcfUtils.getTypedVcfValue((Field)field, (String)singleValue)).toList();
        }
        return value;
    }

    public static Object getTypedVcfValue(Field field, String stringValue) {
        List<Double> typedValue;
        ValueType valueType = field.getValueType();
        switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$ValueType[valueType.ordinal()]) {
            case 1: {
                typedValue = VcfUtils.getVcfValueAsInteger((Object)stringValue);
                break;
            }
            case 2: {
                typedValue = VcfUtils.getVcfValueAsBoolean((Object)stringValue);
                break;
            }
            case 3: {
                typedValue = VcfUtils.getVcfValueAsDouble((Object)stringValue);
                break;
            }
            case 4: 
            case 5: {
                typedValue = VcfUtils.getVcfValueAsString((Object)stringValue);
                break;
            }
            case 6: {
                typedValue = VcfUtils.getVcfValueAsString((Object)stringValue);
                typedValue = Arrays.stream(typedValue.toString().split("-")).map(Double::valueOf).toList();
                break;
            }
            default: {
                throw new UnexpectedEnumException((Enum)valueType);
            }
        }
        return typedValue;
    }

    public static Object getTypedVcfListValue(Field field, String stringValue) {
        String separator = field.getSeparator() != null ? field.getSeparator().toString() : ",";
        String[] stringValues = stringValue.split(separator);
        ArrayList<Object> values = new ArrayList<Object>();
        for (String value : stringValues) {
            values.add(VcfUtils.getTypedVcfValue((Field)field, (String)value));
        }
        return values;
    }

    public static FieldType toFieldType(List<String> fields) {
        String rootField;
        return switch (rootField = fields.get(0)) {
            case "#CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER" -> FieldType.COMMON;
            case "INFO" -> fields.size() > 2 ? FieldType.INFO_VEP : FieldType.INFO;
            case "FORMAT" -> fields.size() > 2 ? FieldType.GENOTYPE : FieldType.FORMAT;
            case "SAMPLE" -> FieldType.SAMPLE;
            default -> throw new UnsupportedFieldException(rootField);
        };
    }
}

