/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner.info;

import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Objects;
import org.molgenis.vcf.decisiontree.runner.info.MissingVepException;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataParser;

public class VepMetadataParserImpl
implements VepMetadataParser {
    private final VepMetadataMapper vepMetadataMapper;

    public VepMetadataParserImpl(VepMetadataMapper vepMetadataMapper) {
        this.vepMetadataMapper = Objects.requireNonNull(vepMetadataMapper);
    }

    public NestedHeaderLine map(VCFHeader header) {
        for (VCFInfoHeaderLine headerLine : header.getInfoHeaderLines()) {
            if (!this.vepMetadataMapper.canMap(headerLine)) continue;
            return this.vepMetadataMapper.map(headerLine);
        }
        throw new MissingVepException();
    }
}

