/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner.info;

import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldImpl;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.ValueCount;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataMapperImpl;
import org.molgenis.vcf.utils.UnexpectedEnumException;
import org.molgenis.vcf.utils.metadata.FieldMetadataService;
import org.molgenis.vcf.utils.model.FieldMetadata;
import org.molgenis.vcf.utils.model.NestedField;
import org.molgenis.vcf.utils.model.NumberType;

public class VepMetadataMapperImpl
implements VepMetadataMapper {
    public static final String ALLELE_NUM = "ALLELE_NUM";
    private static final String INFO_DESCRIPTION_PREFIX = "Consequence annotations from Ensembl VEP. Format: ";
    private final FieldMetadataService fieldMetadataService;

    public VepMetadataMapperImpl(FieldMetadataService fieldMetadataService) {
        this.fieldMetadataService = Objects.requireNonNull(fieldMetadataService);
    }

    public boolean canMap(VCFInfoHeaderLine vcfInfoHeaderLine) {
        String description = vcfInfoHeaderLine.getDescription();
        return description.startsWith(INFO_DESCRIPTION_PREFIX);
    }

    public NestedHeaderLine map(VCFInfoHeaderLine vcfInfoHeaderLine) {
        HashMap<String, org.molgenis.vcf.decisiontree.filter.model.NestedField> nestedFields = new HashMap<String, org.molgenis.vcf.decisiontree.filter.model.NestedField>();
        FieldImpl vepField = FieldImpl.builder().id(vcfInfoHeaderLine.getID()).fieldType(FieldType.INFO).valueType(ValueType.STRING).valueCount(ValueCount.builder().type(ValueCount.Type.VARIABLE).build()).separator(Character.valueOf('|')).build();
        FieldMetadata nestedMetadata = this.fieldMetadataService.load(vcfInfoHeaderLine);
        for (Map.Entry entry : nestedMetadata.getNestedFields().entrySet()) {
            org.molgenis.vcf.decisiontree.filter.model.NestedField nestedField = this.mapNested((String)entry.getKey(), (NestedField)entry.getValue(), (Field)vepField);
            nestedFields.put((String)entry.getKey(), nestedField);
        }
        return NestedHeaderLine.builder().parentField((Field)vepField).nestedFields(nestedFields).build();
    }

    private org.molgenis.vcf.decisiontree.filter.model.NestedField mapNested(String key, NestedField value, Field parent) {
        return org.molgenis.vcf.decisiontree.filter.model.NestedField.nestedBuilder().id(key).fieldType(FieldType.INFO_VEP).valueType(this.mapValueType(value.getType())).valueCount(this.mapValueCount(value.getNumberType(), value.getNumberCount(), value.isRequired())).separator(value.getSeparator()).parent(parent).index(value.getIndex()).build();
    }

    private ValueType mapValueType(org.molgenis.vcf.utils.model.ValueType type) {
        return switch (1.$SwitchMap$org$molgenis$vcf$utils$model$ValueType[type.ordinal()]) {
            case 1 -> ValueType.INTEGER;
            case 2 -> ValueType.FLOAT;
            case 3 -> ValueType.FLAG;
            case 4 -> ValueType.CHARACTER;
            case 5, 6 -> ValueType.STRING;
            default -> throw new UnexpectedEnumException((Enum)type);
        };
    }

    private ValueCount mapValueCount(NumberType numberType, Integer numberCount, boolean required) {
        return ValueCount.builder().type(this.mapNumberType(numberType)).count(numberCount).nullable(!required).build();
    }

    private ValueCount.Type mapNumberType(NumberType numberType) {
        return switch (1.$SwitchMap$org$molgenis$vcf$utils$model$NumberType[numberType.ordinal()]) {
            case 1 -> ValueCount.Type.FIXED;
            case 2 -> ValueCount.Type.A;
            case 3 -> ValueCount.Type.R;
            case 4 -> ValueCount.Type.G;
            case 5 -> ValueCount.Type.VARIABLE;
            default -> throw new UnexpectedEnumException((Enum)numberType);
        };
    }
}

