/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import htsjdk.variant.vcf.VCFFileReader;
import java.nio.file.Path;
import java.util.Objects;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.filter.VcfReader;
import org.molgenis.vcf.decisiontree.runner.VcfReaderFactory;
import org.molgenis.vcf.decisiontree.runner.info.GenotypeMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataParser;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataParserFactory;
import org.molgenis.vcf.utils.metadata.MetadataService;
import org.molgenis.vcf.utils.metadata.MetadataServiceFactory;
import org.springframework.stereotype.Component;

@Component
class VcfReaderFactoryImpl
implements VcfReaderFactory {
    private final VepMetadataParserFactory vepMetadataParserFactory;
    private final GenotypeMetadataMapper genotypeMetadataMapper;
    private final MetadataServiceFactory metadataServiceFactory;

    VcfReaderFactoryImpl(VepMetadataParserFactory vepMetadataParserFactory, GenotypeMetadataMapper genotypeMetadataMapper, MetadataServiceFactory metadataServiceFactory) {
        this.vepMetadataParserFactory = Objects.requireNonNull(vepMetadataParserFactory);
        this.metadataServiceFactory = Objects.requireNonNull(metadataServiceFactory);
        this.genotypeMetadataMapper = Objects.requireNonNull(genotypeMetadataMapper);
    }

    public VcfReader create(Settings settings) {
        VepMetadataParser vepMetadataParser = this.vepMetadataParserFactory.create(settings);
        MetadataService metadataService = this.metadataServiceFactory.create(settings.getMetadataPath());
        Path inputVcfPath = settings.getInputVcfPath();
        boolean strict = settings.isStrict();
        return new VcfReader(new VCFFileReader(inputVcfPath.toFile(), false), vepMetadataParser, this.genotypeMetadataMapper, metadataService, strict);
    }
}

