/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.molgenis.vcf.decisiontree.AppSettings;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.WriterSettings;
import org.molgenis.vcf.decisiontree.filter.RecordWriter;
import org.molgenis.vcf.decisiontree.filter.RecordWriterImpl;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.model.Mode;
import org.molgenis.vcf.decisiontree.runner.RecordWriterFactory;
import org.molgenis.vcf.decisiontree.runner.info.MissingVepException;
import org.molgenis.vcf.utils.utils.HeaderUtils;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
class RecordWriterFactoryImpl
implements RecordWriterFactory {
    private static final String HEADER_VIP_VERSION = "VIP_treeVersion";
    private static final String HEADER_VIP_ARGS = "VIP_treeCommand";
    private static final String INFO_CLASS_DESC = "VIP decision tree classification";
    private static final String INFO_PATH_DESC = "VIP decision tree path (ampersand separated)";
    private static final String INFO_LABELS_DESC = "VIP decision tree labels (ampersand separated)";
    public static final String INFO_CLASS_ID = "VIPC";
    public static final String INFO_PATH_ID = "VIPP";
    public static final String INFO_LABELS_ID = "VIPL";
    public static final String VIPC_S_DESC = "VIP decision tree classification.";
    public static final String VIPC_S_INFO = "VIP decision tree classification (samples).";
    public static final String VIPP_S_DESC = "VIP decision tree path.";
    public static final String VIPL_S_DESC = "VIP decision tree labels.";

    RecordWriterFactoryImpl() {
    }

    public RecordWriter create(VcfMetadata vcfMetadata, Settings settings) {
        WriterSettings writerSettings = settings.getWriterSettings();
        VariantContextWriter vcfWriter = RecordWriterFactoryImpl.createVcfWriter((WriterSettings)writerSettings);
        VCFHeader vcfHeader = RecordWriterFactoryImpl.createHeader((VcfMetadata)vcfMetadata, (Settings)settings);
        vcfWriter.writeHeader(vcfHeader);
        return new RecordWriterImpl(vcfWriter);
    }

    private static VariantContextWriter createVcfWriter(WriterSettings settings) {
        Path outputVcfPath = settings.getOutputVcfPath();
        if (settings.isOverwriteOutput()) {
            try {
                Files.deleteIfExists(outputVcfPath);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else if (Files.exists(outputVcfPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("cannot create '%s' because it already exists.", outputVcfPath));
        }
        return new VariantContextWriterBuilder().clearOptions().setOutputFile(outputVcfPath.toFile()).build();
    }

    private static VCFHeader createHeader(VcfMetadata vcfMetadata, Settings settings) {
        AppSettings appSettings = settings.getAppSettings();
        WriterSettings writerSettings = settings.getWriterSettings();
        VCFHeader vcfHeader = new VCFHeader(vcfMetadata.unwrap());
        vcfHeader.addMetaDataLine(new VCFHeaderLine("VIP_treeVersion", appSettings.getVersion()));
        vcfHeader.addMetaDataLine(new VCFHeaderLine("VIP_treeCommand", String.join((CharSequence)" ", appSettings.getArgs())));
        if (settings.getMode() == Mode.VARIANT) {
            vcfHeader = RecordWriterFactoryImpl.addVariantHeaders((VcfMetadata)vcfMetadata, (WriterSettings)writerSettings, (VCFHeader)vcfHeader);
        } else {
            vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine("VIPC_S", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "VIP decision tree classification (samples)."));
            vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("VIPC_S", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "VIP decision tree classification."));
            if (writerSettings.isWritePath()) {
                vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("VIPP_S", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "VIP decision tree path."));
            }
            if (writerSettings.isWriteLabels()) {
                vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("VIPL_S", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "VIP decision tree labels."));
            }
        }
        return vcfHeader;
    }

    private static VCFHeader addVariantHeaders(VcfMetadata vcfMetadata, WriterSettings writerSettings, VCFHeader vcfHeader) {
        VCFInfoHeaderLine vepHeader = null;
        Set infoHeaderLines = HeaderUtils.fixVcfInfoHeaderLines((VCFHeader)vcfHeader);
        for (VCFInfoHeaderLine infoHeaderLine : infoHeaderLines) {
            if (!infoHeaderLine.getID().equals(vcfMetadata.getVepHeaderLine().getParentField().getId())) continue;
            vepHeader = infoHeaderLine;
            infoHeaderLines.remove(infoHeaderLine);
            break;
        }
        if (vepHeader == null) {
            throw new MissingVepException();
        }
        HashSet<VCFHeaderLine> additionalInfoLines = new HashSet<VCFHeaderLine>();
        StringBuilder vepDescriptionBuilder = new StringBuilder(vepHeader.getDescription());
        vepDescriptionBuilder.append("|");
        vepDescriptionBuilder.append("VIPC");
        additionalInfoLines.add(new VCFHeaderLine("VIPC", "VIP decision tree classification"));
        if (writerSettings.isWritePath()) {
            vepDescriptionBuilder.append("|");
            vepDescriptionBuilder.append("VIPP");
            additionalInfoLines.add(new VCFHeaderLine("VIPP", "VIP decision tree path (ampersand separated)"));
        }
        if (writerSettings.isWriteLabels()) {
            vepDescriptionBuilder.append("|");
            vepDescriptionBuilder.append("VIPL");
            additionalInfoLines.add(new VCFHeaderLine("VIPL", "VIP decision tree labels (ampersand separated)"));
        }
        HashSet<Object> headerLines = new HashSet<Object>();
        headerLines.add(new VCFInfoHeaderLine(vepHeader.getID(), vepHeader.getCountType(), vepHeader.getType(), vepDescriptionBuilder.toString(), vepHeader.getSource(), vepHeader.getVersion()));
        headerLines.addAll(HeaderUtils.fixVcfFormatHeaderLines((VCFHeader)vcfHeader));
        headerLines.addAll(HeaderUtils.fixVcfFilterHeaderLines((VCFHeader)vcfHeader));
        headerLines.addAll(vcfHeader.getOtherHeaderLines());
        headerLines.addAll(vcfHeader.getContigLines());
        headerLines.addAll(infoHeaderLines);
        headerLines.addAll(additionalInfoLines);
        vcfHeader = new VCFHeader(headerLines, vcfHeader.getGenotypeSamples());
        return vcfHeader;
    }
}

