/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import java.util.Collection;
import java.util.Set;
import org.molgenis.vcf.decisiontree.filter.model.DecisionType;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.MissingField;
import org.molgenis.vcf.decisiontree.filter.model.ValueCount;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolQuery;
import org.molgenis.vcf.decisiontree.loader.model.ConfigMultiMode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigOperator;
import org.molgenis.vcf.decisiontree.runner.CountMismatchException;
import org.molgenis.vcf.decisiontree.runner.FileValueNotAllowedException;
import org.molgenis.vcf.decisiontree.runner.QueryValidator;
import org.molgenis.vcf.decisiontree.runner.QueryValidatorImpl;
import org.molgenis.vcf.decisiontree.runner.UnsupportedValueCountException;
import org.molgenis.vcf.decisiontree.runner.UnsupportedValueCountTypeException;
import org.molgenis.vcf.decisiontree.runner.UnsupportedValueTypeException;
import org.molgenis.vcf.utils.UnexpectedEnumException;
import org.springframework.stereotype.Component;

@Component
public class QueryValidatorImpl
implements QueryValidator {
    public static final Set<ConfigOperator> ALLOWED_FILE_OPERATORS = Set.of(ConfigOperator.IN, ConfigOperator.NOT_IN, ConfigOperator.CONTAINS, ConfigOperator.NOT_CONTAINS, ConfigOperator.CONTAINS_ALL, ConfigOperator.CONTAINS_ANY, ConfigOperator.CONTAINS_NONE);

    public void validateBooleanNode(ConfigBoolQuery configBoolQuery, Field field) {
        if (!(field instanceof MissingField)) {
            switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$loader$model$ConfigOperator[configBoolQuery.getOperator().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.validateLesserGreater(field, configBoolQuery);
                    break;
                }
                case 5: 
                case 6: {
                    this.validateIn(field);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.validateContains(field, configBoolQuery);
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.validateEquals(field, configBoolQuery);
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    this.validateRange(field, configBoolQuery);
                    break;
                }
                default: {
                    throw new UnexpectedEnumException((Enum)configBoolQuery.getOperator());
                }
            }
        }
    }

    private void validateRange(Field field, ConfigBoolQuery query) {
        this.validateFileValueAllowed(query, field);
        if (field.getValueType() != ValueType.RANGE) {
            throw new UnsupportedValueTypeException(field, DecisionType.BOOL);
        }
        this.validateRangeAlleleCount(field, DecisionType.BOOL);
    }

    private void validateRangeAlleleCount(Field field, DecisionType bool) {
        if (field.getValueCount().getType() != ValueCount.Type.FIXED && field.getValueCount().getType() == ValueCount.Type.FIXED && field.getValueCount().getCount() != 2) {
            throw new UnsupportedOperationException("FIXME: unsupported count for range.");
        }
    }

    private void validateFileValueAllowed(ConfigBoolQuery query, Field field) {
        ConfigOperator operator = query.getOperator();
        if (!ALLOWED_FILE_OPERATORS.contains(operator) && query.getValue().toString().startsWith("file:")) {
            throw new FileValueNotAllowedException(operator, ALLOWED_FILE_OPERATORS.toString(), field.getId());
        }
    }

    private void validateLesserGreater(Field field, ConfigBoolQuery query) {
        this.validateFileValueAllowed(query, field);
        if (field.getValueType() != ValueType.FLOAT && field.getValueType() != ValueType.INTEGER) {
            throw new UnsupportedValueTypeException(field, DecisionType.BOOL);
        }
        if (query.getMultiMode() == ConfigMultiMode.SINGLE) {
            this.validateSingleOrPerAlleleCount(field, DecisionType.BOOL, ConfigOperator.IN);
        }
    }

    private void validateEquals(Field field, ConfigBoolQuery configBoolQuery) {
        this.validateFileValueAllowed(configBoolQuery, field);
        if (field.getSeparator() != null && !(configBoolQuery.getValue() instanceof Collection)) {
            throw new CountMismatchException(configBoolQuery);
        }
    }

    private void validateIn(Field field) {
        if (field.getValueType() == ValueType.FLAG || field.getValueType() == ValueType.FLOAT) {
            throw new UnsupportedValueTypeException(field, DecisionType.BOOL);
        }
        this.validateSingleOrPerAlleleCount(field, DecisionType.BOOL, ConfigOperator.IN);
    }

    private void validateContains(Field field, ConfigBoolQuery configBoolQuery) {
        this.validateFileValueAllowed(configBoolQuery, field);
        if (field.getValueType() == ValueType.FLAG || field.getValueType() == ValueType.FLOAT) {
            throw new UnsupportedValueTypeException(field, DecisionType.BOOL);
        }
        if (field.getValueCount().getType() == ValueCount.Type.FIXED && field.getValueCount().getCount() == 1) {
            throw new UnsupportedValueCountException(field, DecisionType.BOOL, ConfigOperator.CONTAINS);
        }
    }

    private void validateSingleOrPerAlleleCount(Field field, DecisionType decisionType, ConfigOperator configOperator) {
        if (field.getValueCount().getType() == ValueCount.Type.G || field.getValueCount().getType() == ValueCount.Type.VARIABLE) {
            throw new UnsupportedValueCountTypeException(field, decisionType, configOperator);
        }
        if (field.getValueCount().getType() == ValueCount.Type.FIXED && field.getValueCount().getCount() != 1) {
            throw new UnsupportedValueCountException(field, decisionType, configOperator);
        }
    }

    public void validateCategoricalNode(Field field) {
        if (!(field instanceof MissingField)) {
            if (field.getValueType() == ValueType.FLAG || field.getValueType() == ValueType.FLOAT) {
                throw new UnsupportedValueTypeException(field, DecisionType.CATEGORICAL);
            }
            this.validateSingleOrPerAlleleCount(field, DecisionType.CATEGORICAL, ConfigOperator.IN);
        }
    }
}

