/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import java.util.Objects;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.filter.Classifier;
import org.molgenis.vcf.decisiontree.filter.ClassifierImpl;
import org.molgenis.vcf.decisiontree.filter.ConsequenceAnnotator;
import org.molgenis.vcf.decisiontree.filter.DecisionTreeExecutor;
import org.molgenis.vcf.decisiontree.filter.RecordWriter;
import org.molgenis.vcf.decisiontree.filter.SampleAnnotator;
import org.molgenis.vcf.decisiontree.filter.SampleClassifierImpl;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.model.DecisionTree;
import org.molgenis.vcf.decisiontree.filter.model.SamplesContext;
import org.molgenis.vcf.decisiontree.runner.ClassifierFactory;
import org.molgenis.vcf.decisiontree.runner.DecisionTreeExecutorFactory;
import org.molgenis.vcf.decisiontree.runner.VepHelper;
import org.springframework.stereotype.Component;

@Component
class ClassifierFactoryImpl
implements ClassifierFactory {
    private final DecisionTreeExecutorFactory decisionTreeExecutorFactory;

    ClassifierFactoryImpl(DecisionTreeExecutorFactory decisionTreeExecutorFactory) {
        this.decisionTreeExecutorFactory = Objects.requireNonNull(decisionTreeExecutorFactory);
    }

    public Classifier create(Settings settings, DecisionTree decisionTree, ConsequenceAnnotator consequenceAnnotator, RecordWriter recordWriter, VcfMetadata vcfMetadata) {
        DecisionTreeExecutor decisionTreeExecutor = this.decisionTreeExecutorFactory.create(settings.getWriterSettings());
        return new ClassifierImpl(decisionTreeExecutor, new VepHelper(), decisionTree, consequenceAnnotator, recordWriter, vcfMetadata);
    }

    public Classifier create(Settings settings, DecisionTree decisionTree, RecordWriter recordWriter, SampleAnnotator sampleAnnotator, SamplesContext samplesContext) {
        DecisionTreeExecutor decisionTreeExecutor = this.decisionTreeExecutorFactory.create(settings.getWriterSettings());
        return new SampleClassifierImpl(decisionTreeExecutor, new VepHelper(), decisionTree, recordWriter, sampleAnnotator, samplesContext);
    }
}

