/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.loader;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import org.molgenis.vcf.decisiontree.loader.ConfigDecisionTreeLoader;
import org.molgenis.vcf.decisiontree.loader.ConfigDecisionTreeValidator;
import org.molgenis.vcf.decisiontree.loader.ConfigNodeDeserializer;
import org.molgenis.vcf.decisiontree.loader.PathDeserializer;
import org.molgenis.vcf.decisiontree.loader.model.ConfigDecisionTree;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNode;
import org.springframework.stereotype.Component;

@Component
public class ConfigDecisionTreeLoaderImpl
implements ConfigDecisionTreeLoader {
    private final ConfigDecisionTreeValidator configDecisionTreeValidator;

    ConfigDecisionTreeLoaderImpl(ConfigDecisionTreeValidator configDecisionTreeValidator) {
        this.configDecisionTreeValidator = Objects.requireNonNull(configDecisionTreeValidator);
    }

    public ConfigDecisionTree load(Path decisionTreeConfigPath) {
        ConfigDecisionTree configDecisionTree;
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ConfigNode.class, (JsonDeserializer)new ConfigNodeDeserializer());
        module.addDeserializer(Path.class, (JsonDeserializer)new PathDeserializer());
        mapper.registerModule((Module)module);
        try {
            configDecisionTree = (ConfigDecisionTree)mapper.readValue(decisionTreeConfigPath.toFile(), ConfigDecisionTree.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.configDecisionTreeValidator.validate(configDecisionTree);
        return configDecisionTree;
    }
}

