/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.molgenis.vcf.decisiontree.filter.InvalidNumberOfTokensException;
import org.molgenis.vcf.decisiontree.filter.UnknownFieldException;
import org.molgenis.vcf.decisiontree.filter.UnsupportedFieldException;
import org.molgenis.vcf.decisiontree.filter.UnsupportedNestedFieldException;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldImpl;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.MissingField;
import org.molgenis.vcf.decisiontree.filter.model.ValueCount;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.molgenis.vcf.decisiontree.utils.VcfUtils;
import org.molgenis.vcf.utils.UnexpectedEnumException;
import org.molgenis.vcf.utils.metadata.MetadataService;
import org.molgenis.vcf.utils.model.FieldMetadata;
import org.molgenis.vcf.utils.model.NumberType;

/*
 * Exception performing whole class analysis ignored.
 */
public class VcfMetadata {
    private final VCFHeader vcfHeader;
    private final boolean strict;
    private final NestedHeaderLine nestedVepHeaderLine;
    private final NestedHeaderLine nestedGenotypeHeaderLine;
    private final MetadataService metadataService;

    public VcfMetadata(VCFHeader vcfHeader, NestedHeaderLine nestedVepHeaderLine, NestedHeaderLine nestedGenotypeHeaderLine, MetadataService metadataService, boolean strict) {
        this.vcfHeader = Objects.requireNonNull(vcfHeader);
        this.nestedVepHeaderLine = Objects.requireNonNull(nestedVepHeaderLine);
        this.nestedGenotypeHeaderLine = Objects.requireNonNull(nestedGenotypeHeaderLine);
        this.metadataService = Objects.requireNonNull(metadataService);
        this.strict = strict;
    }

    public Field getField(String fieldId) {
        List<String> fieldTokens = Arrays.asList(fieldId.split("/"));
        FieldType fieldType = VcfUtils.toFieldType(fieldTokens);
        Field field = switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$FieldType[fieldType.ordinal()]) {
            case 1 -> this.toCommonField(fieldTokens);
            case 2, 3 -> this.toCompoundField(fieldTokens, fieldType);
            case 4 -> VcfMetadata.toSampleField(fieldTokens);
            case 5 -> this.toNestedField(fieldTokens, fieldType, this.nestedVepHeaderLine);
            case 6 -> this.toNestedField(fieldTokens, fieldType, this.nestedGenotypeHeaderLine);
            default -> throw new UnexpectedEnumException((Enum)fieldType);
        };
        return field;
    }

    private static Field toSampleField(List<String> fieldTokens) {
        ValueType valueType;
        if (fieldTokens.size() != 2) {
            throw new InvalidNumberOfTokensException(fieldTokens, FieldType.SAMPLE, 2);
        }
        String field = fieldTokens.get(1);
        return FieldImpl.builder().id(field).fieldType(FieldType.SAMPLE).valueType(valueType).valueCount(switch (field.toUpperCase()) {
            case "PROBAND" -> {
                valueType = ValueType.FLAG;
                yield ValueCount.builder().type(ValueCount.Type.FIXED).count(Integer.valueOf(1)).build();
            }
            case "ID", "AFFECTED_STATUS", "SEX", "FATHER_ID", "MOTHER_ID", "FAMILY_ID" -> {
                valueType = ValueType.STRING;
                yield ValueCount.builder().type(ValueCount.Type.FIXED).count(Integer.valueOf(1)).build();
            }
            case "PHENOTYPES" -> {
                valueType = ValueType.STRING;
                yield ValueCount.builder().type(ValueCount.Type.VARIABLE).nullable(true).build();
            }
            default -> throw new UnsupportedFieldException(field);
        }).build();
    }

    private Field toNestedField(List<String> fieldTokens, FieldType fieldType, NestedHeaderLine nestedHeaderLine) {
        if (fieldTokens.size() != 3) {
            throw new InvalidNumberOfTokensException(fieldTokens, fieldType, 2);
        }
        String field = fieldTokens.get(1);
        String nestedFieldId = fieldTokens.get(2);
        if (!field.equals(nestedHeaderLine.getParentField().getId())) {
            if (this.strict) {
                throw new UnsupportedNestedFieldException(field);
            }
            return new MissingField(field);
        }
        Field nestedField = nestedHeaderLine.getField(nestedFieldId);
        if (nestedField instanceof MissingField && this.strict) {
            throw new UnknownFieldException(nestedFieldId, FieldType.INFO_VEP);
        }
        return nestedField;
    }

    private FieldImpl toCommonField(List<String> fieldTokens) {
        ValueType valueType;
        String field;
        if (fieldTokens.size() > 1) {
            throw new InvalidNumberOfTokensException(fieldTokens, FieldType.COMMON, 1);
        }
        return FieldImpl.builder().id(field).fieldType(FieldType.COMMON).valueType(valueType).valueCount(switch (field = fieldTokens.get(0)) {
            case "#CHROM", "REF" -> {
                valueType = ValueType.STRING;
                yield ValueCount.builder().type(ValueCount.Type.FIXED).count(Integer.valueOf(1)).build();
            }
            case "POS" -> {
                valueType = ValueType.INTEGER;
                yield ValueCount.builder().type(ValueCount.Type.FIXED).count(Integer.valueOf(1)).build();
            }
            case "ID", "FILTER", "ALT" -> {
                valueType = ValueType.STRING;
                yield ValueCount.builder().type(ValueCount.Type.VARIABLE).nullable(true).build();
            }
            case "QUAL" -> {
                valueType = ValueType.FLOAT;
                yield ValueCount.builder().type(ValueCount.Type.FIXED).count(Integer.valueOf(1)).nullable(true).build();
            }
            default -> throw new UnsupportedFieldException(field);
        }).build();
    }

    private Field toCompoundField(List<String> fieldTokens, FieldType fieldType) {
        if (fieldTokens.size() != 2) {
            throw new InvalidNumberOfTokensException(fieldTokens, fieldType, 2);
        }
        String field = fieldTokens.get(1);
        if (fieldType == FieldType.INFO && this.metadataService.getFieldMetadatas() != null && this.metadataService.getFieldMetadatas().getInfo().containsKey(field)) {
            FieldMetadata fieldMetadata = (FieldMetadata)this.metadataService.getFieldMetadatas().getInfo().get(field);
            return FieldImpl.builder().id(field).fieldType(FieldType.INFO).valueType(this.mapValueType(fieldMetadata.getField().getType())).valueCount(this.mapValueCount(fieldMetadata.getField().getNumberType(), fieldMetadata.getField().getNumberCount(), fieldMetadata.getField().isRequired())).separator(fieldMetadata.getField().getSeparator()).build();
        }
        if (fieldType == FieldType.FORMAT && this.metadataService.getFieldMetadatas() != null && this.metadataService.getFieldMetadatas().getFormat().containsKey(field)) {
            org.molgenis.vcf.utils.model.Field formatFieldMetadata = (org.molgenis.vcf.utils.model.Field)this.metadataService.getFieldMetadatas().getFormat().get(field);
            return FieldImpl.builder().id(field).fieldType(FieldType.FORMAT).valueType(this.mapValueType(formatFieldMetadata.getType())).valueCount(this.mapValueCount(formatFieldMetadata.getNumberType(), formatFieldMetadata.getNumberCount(), formatFieldMetadata.isRequired())).separator(formatFieldMetadata.getSeparator()).build();
        }
        VCFCompoundHeaderLine vcfCompoundHeaderLine = this.getVcfCompoundHeaderLine(fieldType, field);
        if (vcfCompoundHeaderLine == null) {
            return new MissingField(field);
        }
        VCFHeaderLineType lineType = vcfCompoundHeaderLine.getType();
        ValueType valueType = switch (1.$SwitchMap$htsjdk$variant$vcf$VCFHeaderLineType[lineType.ordinal()]) {
            case 1 -> ValueType.INTEGER;
            case 2 -> ValueType.FLOAT;
            case 3 -> ValueType.STRING;
            case 4 -> ValueType.CHARACTER;
            case 5 -> ValueType.FLAG;
            default -> throw new UnexpectedEnumException((Enum)lineType);
        };
        ValueCount.ValueCountBuilder builder = ValueCount.builder();
        VCFHeaderLineCount countType = vcfCompoundHeaderLine.getCountType();
        switch (1.$SwitchMap$htsjdk$variant$vcf$VCFHeaderLineCount[countType.ordinal()]) {
            case 1: {
                int count = vcfCompoundHeaderLine.getCount();
                builder.type(ValueCount.Type.FIXED).count(Integer.valueOf(count)).nullable(valueType != ValueType.FLAG);
                break;
            }
            case 2: {
                builder.type(ValueCount.Type.A).nullable(true);
                break;
            }
            case 3: {
                builder.type(ValueCount.Type.R).nullable(true);
                break;
            }
            case 4: {
                builder.type(ValueCount.Type.G).nullable(true);
                break;
            }
            case 5: {
                builder.type(ValueCount.Type.VARIABLE).nullable(true);
                break;
            }
            default: {
                throw new UnexpectedEnumException((Enum)countType);
            }
        }
        return FieldImpl.builder().id(field).fieldType(fieldType).valueType(valueType).valueCount(builder.build()).build();
    }

    private ValueType mapValueType(org.molgenis.vcf.utils.model.ValueType type) {
        return switch (1.$SwitchMap$org$molgenis$vcf$utils$model$ValueType[type.ordinal()]) {
            case 1 -> ValueType.INTEGER;
            case 2 -> ValueType.FLOAT;
            case 3 -> ValueType.FLAG;
            case 4 -> ValueType.CHARACTER;
            case 5, 6 -> ValueType.STRING;
            case 7 -> ValueType.RANGE;
            default -> throw new UnexpectedEnumException((Enum)type);
        };
    }

    private ValueCount mapValueCount(NumberType numberType, Integer numberCount, boolean required) {
        return ValueCount.builder().type(this.mapNumberType(numberType)).count(numberCount).nullable(!required).build();
    }

    private ValueCount.Type mapNumberType(NumberType numberType) {
        return switch (1.$SwitchMap$org$molgenis$vcf$utils$model$NumberType[numberType.ordinal()]) {
            case 1 -> ValueCount.Type.FIXED;
            case 2 -> ValueCount.Type.A;
            case 3 -> ValueCount.Type.R;
            case 4 -> ValueCount.Type.G;
            case 5 -> ValueCount.Type.VARIABLE;
            default -> throw new UnexpectedEnumException((Enum)numberType);
        };
    }

    private VCFCompoundHeaderLine getVcfCompoundHeaderLine(FieldType fieldType, String field) {
        VCFFormatHeaderLine vcfCompoundHeaderLine;
        switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$FieldType[fieldType.ordinal()]) {
            case 3: {
                vcfCompoundHeaderLine = this.vcfHeader.getFormatHeaderLine(field);
                if (vcfCompoundHeaderLine != null || !this.strict) break;
                throw new UnknownFieldException(field, fieldType);
            }
            case 2: {
                vcfCompoundHeaderLine = this.vcfHeader.getInfoHeaderLine(field);
                if (vcfCompoundHeaderLine != null || !this.strict) break;
                throw new UnknownFieldException(field, FieldType.INFO_VEP);
            }
            default: {
                throw new UnexpectedEnumException((Enum)fieldType);
            }
        }
        return vcfCompoundHeaderLine;
    }

    public static boolean isSingleValueField(Field field) {
        return field.getValueCount().getType() == ValueCount.Type.FIXED && field.getValueCount().getCount() <= 1;
    }

    public Map<String, Integer> getSampleNameToOffset() {
        return this.vcfHeader.getSampleNameToOffset();
    }

    public VCFHeader unwrap() {
        return this.vcfHeader;
    }

    public NestedHeaderLine getVepHeaderLine() {
        return this.nestedVepHeaderLine;
    }
}

