/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.molgenis.vcf.decisiontree.filter.model.Decision;
import org.molgenis.vcf.decisiontree.filter.model.Label;
import org.molgenis.vcf.decisiontree.filter.model.Node;

public class DecisionUtils {
    private DecisionUtils() {
    }

    public static String getDecisionLabelsString(Decision decision) {
        String decisionLabel = "";
        Set labels = decision.getLabels();
        if (!labels.isEmpty()) {
            decisionLabel = labels.stream().map(Label::getId).sorted().collect(Collectors.joining("&"));
        }
        return decisionLabel;
    }

    public static String getDecisionsPath(Decision decision) {
        List path = decision.getPath();
        String decisionPath = !path.isEmpty() ? path.stream().map(Node::getId).collect(Collectors.joining("&")) : ".";
        return decisionPath;
    }

    public static String getDecisionClass(Decision decision) {
        String infoClassValue = decision == null ? "" : decision.getClazz();
        return infoClassValue;
    }
}

