/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.molgenis.vcf.decisiontree.filter.BaseBoolNodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.NodeEvaluator;
import org.molgenis.vcf.decisiontree.filter.Variant;
import org.molgenis.vcf.decisiontree.filter.model.BoolQuery;
import org.molgenis.vcf.decisiontree.filter.model.DecisionNode;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.MultiMode;
import org.molgenis.vcf.decisiontree.filter.model.SampleContext;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.molgenis.vcf.utils.UnexpectedEnumException;
import org.springframework.lang.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
interface BaseBoolNodeEvaluator<T extends DecisionNode>
extends NodeEvaluator<T> {
    default public boolean isMissingValue(Object value) {
        return value == null || value instanceof Collection && ((Collection)value).isEmpty();
    }

    default public boolean executeQuery(BoolQuery boolQuery, Object value) {
        MultiMode multiMode = boolQuery.getMultiMode();
        Field field = boolQuery.getField();
        BoolQuery.Operator operator = boolQuery.getOperator();
        Object queryValue = boolQuery.getValue();
        switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$MultiMode[multiMode.ordinal()]) {
            case 1: {
                return this.executeSingleQuery(value, field, operator, queryValue);
            }
            case 2: {
                for (Object singleValue : (Collection)value) {
                    if (!this.executeSingleQuery(singleValue, field, operator, queryValue)) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                for (Object singleValue : (Collection)value) {
                    if (this.executeSingleQuery(singleValue, field, operator, queryValue)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new UnexpectedEnumException((Enum)multiMode);
    }

    private boolean executeSingleQuery(Object value, Field field, BoolQuery.Operator operator, Object queryValue) {
        return switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$BoolQuery$Operator[operator.ordinal()]) {
            case 1 -> value.equals(queryValue);
            case 2 -> this.executeSequenceEqualsQuery(field, value, queryValue);
            case 3 -> !this.executeSequenceEqualsQuery(field, value, queryValue);
            case 4 -> !value.equals(queryValue);
            case 5 -> this.executeLessQuery(field, value, queryValue);
            case 6 -> !this.executeGreaterQuery(field, value, queryValue);
            case 7 -> this.executeGreaterQuery(field, value, queryValue);
            case 8 -> !this.executeLessQuery(field, value, queryValue);
            case 9 -> this.executeInQuery(value, (Collection)queryValue);
            case 10 -> !this.executeInQuery(value, (Collection)queryValue);
            case 11 -> this.executeContainsQuery((Collection)value, queryValue);
            case 12 -> !this.executeContainsQuery((Collection)value, queryValue);
            case 13 -> this.executeContainsAllQuery((Collection)value, (Collection)queryValue);
            case 14 -> this.executeContainsAnyQuery((Collection)value, (Collection)queryValue);
            case 15 -> this.executeContainsNoneQuery((Collection)value, (Collection)queryValue);
            case 16 -> this.executeRangeOverlapsQuery(field, (Collection)value, queryValue);
            case 17 -> this.executeRangeBelowQuery(field, (Collection)value, queryValue);
            case 18 -> this.executeRangeAboveQuery(field, (Collection)value, queryValue);
            default -> throw new UnexpectedEnumException((Enum)operator);
        };
    }

    default public boolean executeRangeAboveQuery(Field field, Collection<?> values, Object queryValue) {
        switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$ValueType[field.getValueType().ordinal()]) {
            case 1: {
                List integerList = (List)values;
                Integer minInteger = (Integer)Collections.min(integerList);
                return minInteger > Integer.valueOf(queryValue.toString());
            }
            case 2: {
                List doubleList = (List)values;
                Double minDouble = (Double)Collections.min(doubleList);
                return minDouble > Double.valueOf(queryValue.toString());
            }
        }
        throw new UnexpectedEnumException((Enum)field.getValueType());
    }

    default public boolean executeRangeBelowQuery(Field field, Collection<?> values, Object queryValue) {
        switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$ValueType[field.getValueType().ordinal()]) {
            case 3: {
                List doubleList = (List)values;
                Double maxDouble = (Double)Collections.max(doubleList);
                return maxDouble < Double.valueOf(queryValue.toString());
            }
        }
        throw new UnexpectedEnumException((Enum)field.getValueType());
    }

    default public boolean executeRangeOverlapsQuery(Field field, Collection<?> values, Object queryValue) {
        switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$ValueType[field.getValueType().ordinal()]) {
            case 1: {
                List integerList = (List)values;
                Integer maxInteger = (Integer)Collections.max(integerList);
                Integer minInteger = (Integer)Collections.min(integerList);
                return maxInteger >= Integer.valueOf(queryValue.toString()) && minInteger <= Integer.valueOf(queryValue.toString());
            }
            case 2: {
                List doubleList = (List)values;
                Double maxDouble = (Double)Collections.max(doubleList);
                Double minDouble = (Double)Collections.min(doubleList);
                return maxDouble >= Double.valueOf(queryValue.toString()) && minDouble <= Double.valueOf(queryValue.toString());
            }
        }
        throw new UnexpectedEnumException((Enum)field.getValueType());
    }

    default public boolean executeSequenceEqualsQuery(Field field, Object value, Object queryValue) {
        if (field.getValueType() != ValueType.STRING) {
            throw new UnexpectedEnumException((Enum)field.getValueType());
        }
        String actualValue = value.toString();
        if (queryValue == null) {
            return false;
        }
        String requestedValue = queryValue.toString();
        if (actualValue.length() != requestedValue.length()) {
            return false;
        }
        String shiftedValue = "";
        for (int i = 0; i < actualValue.length(); ++i) {
            shiftedValue = i != 0 ? this.shift(shiftedValue) : actualValue;
            if (!BaseBoolNodeEvaluator.sequenceMatch((String)shiftedValue, (String)requestedValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean sequenceMatch(String actualValue, String requestedValue) {
        for (int i = 0; i < actualValue.length(); ++i) {
            if (BaseBoolNodeEvaluator.isIupacMatch((Character)Character.valueOf(requestedValue.charAt(i)), (Character)Character.valueOf(actualValue.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private static boolean isIupacMatch(Character iupac, Character base) {
        if (iupac.equals(Character.valueOf('B')) || iupac.equals(Character.valueOf('B')) || iupac.equals(Character.valueOf('B'))) {
            throw new UnsupportedOperationException(String.format("IUPAC value '%s' is not supported.", iupac));
        }
        HashMap<Character, Set<Character>> iupacMap = new HashMap<Character, Set<Character>>();
        iupacMap.put(Character.valueOf('G'), Set.of(Character.valueOf('G')));
        iupacMap.put(Character.valueOf('A'), Set.of(Character.valueOf('A')));
        iupacMap.put(Character.valueOf('T'), Set.of(Character.valueOf('T')));
        iupacMap.put(Character.valueOf('C'), Set.of(Character.valueOf('C')));
        iupacMap.put(Character.valueOf('R'), Set.of(Character.valueOf('G'), Character.valueOf('A')));
        iupacMap.put(Character.valueOf('Y'), Set.of(Character.valueOf('T'), Character.valueOf('C')));
        iupacMap.put(Character.valueOf('M'), Set.of(Character.valueOf('A'), Character.valueOf('C')));
        iupacMap.put(Character.valueOf('K'), Set.of(Character.valueOf('G'), Character.valueOf('T')));
        iupacMap.put(Character.valueOf('S'), Set.of(Character.valueOf('G'), Character.valueOf('C')));
        iupacMap.put(Character.valueOf('W'), Set.of(Character.valueOf('A'), Character.valueOf('T')));
        iupacMap.put(Character.valueOf('H'), Set.of(Character.valueOf('A'), Character.valueOf('C'), Character.valueOf('T')));
        iupacMap.put(Character.valueOf('N'), Set.of(Character.valueOf('G'), Character.valueOf('A'), Character.valueOf('T'), Character.valueOf('C')));
        Set values = (Set)iupacMap.get(iupac);
        if (values.isEmpty()) {
            throw new UnsupportedOperationException(String.format("'%s' is not a valid IUPAC base.", iupac));
        }
        return values.contains(base);
    }

    private String shift(String sequence) {
        char first = sequence.charAt(0);
        return sequence.substring(1) + first;
    }

    default public boolean executeLessQuery(Field field, Object value, Object queryValue) {
        return switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$ValueType[field.getValueType().ordinal()]) {
            case 1 -> (Integer)value < (Integer)queryValue;
            case 2 -> (Double)value < (Double)queryValue;
            default -> throw new UnexpectedEnumException((Enum)field.getValueType());
        };
    }

    default public boolean executeGreaterQuery(Field field, Object value, Object queryValue) {
        return switch (1.$SwitchMap$org$molgenis$vcf$decisiontree$filter$model$ValueType[field.getValueType().ordinal()]) {
            case 1 -> (Integer)value > (Integer)queryValue;
            case 2 -> (Double)value > (Double)queryValue;
            default -> throw new UnexpectedEnumException((Enum)field.getValueType());
        };
    }

    default public boolean executeContainsQuery(Collection<?> values, Object queryValue) {
        return values.contains(queryValue);
    }

    default public boolean executeContainsAllQuery(Collection<?> values, Collection<?> queryValues) {
        return values.containsAll(queryValues);
    }

    default public boolean executeContainsAnyQuery(Collection<?> values, Collection<?> queryValues) {
        for (Object queryValue : queryValues) {
            if (!values.contains(queryValue)) continue;
            return true;
        }
        return false;
    }

    default public boolean executeContainsNoneQuery(Collection<?> values, Collection<?> queryValues) {
        return !this.executeContainsAnyQuery(values, queryValues);
    }

    default public boolean executeInQuery(Object value, Collection<?> queryValues) {
        return queryValues.contains(value);
    }

    default public BoolQuery postProcessQuery(BoolQuery query, Variant variant, @Nullable SampleContext sampleContext) {
        String stringQueryValue = query.getValue().toString();
        if (stringQueryValue.startsWith("field:")) {
            String fieldId = stringQueryValue.substring("field:".length());
            query = BoolQuery.builder().multiMode(query.getMultiMode()).field(query.getField()).operator(query.getOperator()).value(variant.getValue(variant.getVcfMetadata().getField(fieldId), sampleContext)).build();
        }
        return query;
    }
}

