/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree;

import ch.qos.logback.classic.Level;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.molgenis.vcf.decisiontree.AppCommandLineOptions;
import org.molgenis.vcf.decisiontree.AppCommandLineToSettingsMapper;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.runner.AppRunner;
import org.molgenis.vcf.decisiontree.runner.AppRunnerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
class AppCommandLineRunner
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppCommandLineRunner.class);
    private static final int STATUS_MISC_ERROR = 1;
    private static final int STATUS_COMMAND_LINE_USAGE_ERROR = 64;
    private final String appName;
    private final String appVersion;
    private final AppCommandLineToSettingsMapper appCommandLineToSettingsMapper;
    private final AppRunnerFactory appRunnerFactory;
    private final CommandLineParser commandLineParser;

    AppCommandLineRunner(@Value(value="${app.name}") String appName, @Value(value="${app.version}") String appVersion, AppCommandLineToSettingsMapper appCommandLineToSettingsMapper, AppRunnerFactory appRunnerFactory) {
        this.appName = Objects.requireNonNull(appName);
        this.appVersion = Objects.requireNonNull(appVersion);
        this.appCommandLineToSettingsMapper = Objects.requireNonNull(appCommandLineToSettingsMapper);
        this.appRunnerFactory = Objects.requireNonNull(appRunnerFactory);
        this.commandLineParser = new DefaultParser();
    }

    public void run(String ... args) {
        Locale.setDefault(Locale.Category.FORMAT, Locale.US);
        if (args.length == 1 && (args[0].equals("-v") || args[0].equals("--version"))) {
            LOGGER.info("{} {}", (Object)this.appName, (Object)this.appVersion);
            return;
        }
        for (String arg : args) {
            if (!arg.equals("-d") && !arg.equals("-debug")) continue;
            Logger rootLogger = LoggerFactory.getLogger((String)"ROOT");
            if (!(rootLogger instanceof ch.qos.logback.classic.Logger)) {
                throw new ClassCastException("Expected root logger to be a logback logger");
            }
            ((ch.qos.logback.classic.Logger)rootLogger).setLevel(Level.DEBUG);
            break;
        }
        try {
            Settings settings = this.createSettings(args);
            try (AppRunner appRunner = this.appRunnerFactory.create(settings);){
                appRunner.run();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    private Settings createSettings(String ... args) {
        CommandLine commandLine = null;
        try {
            commandLine = this.commandLineParser.parse(AppCommandLineOptions.getAppOptions(), args);
        }
        catch (ParseException e) {
            this.logException(e);
            System.exit(64);
        }
        AppCommandLineOptions.validateCommandLine((CommandLine)commandLine);
        return this.appCommandLineToSettingsMapper.map(commandLine, args);
    }

    private void logException(ParseException e) {
        LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(null);
        String cmdLineSyntax = "java -jar " + this.appName + ".jar";
        formatter.printHelp(cmdLineSyntax, AppCommandLineOptions.getAppOptions(), true);
        System.out.println();
        formatter.printHelp(cmdLineSyntax, AppCommandLineOptions.getAppVersionOptions(), true);
    }
}

