/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.annotator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.molgenis.vcf.annotator.model.Settings;

public class TSVReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Map<String, String>> readTSV(File file, String rowKey) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line = br.readLine();
            if (line == null) {
                Map<String, Map<String, String>> map = Map.of();
                return map;
            }
            String[] headers = line.split("\t");
            while ((line = br.readLine()) != null) {
                String[] values = line.split("\t", -1);
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                for (int i = 0; i < headers.length; ++i) {
                    String key = headers[i].replace("\"", "");
                    String value = i < values.length ? values[i].replace("\"", "") : "";
                    row.put(key, value);
                }
                result.put(((String)row.get(rowKey)).split("\\.")[0], row);
            }
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String createKey(Settings settings, Map<String, String> row) {
        return null;
    }
}

