/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.molgenis.vcf.annotator.MappingReader;
import org.molgenis.vcf.annotator.TSVReader;
import org.molgenis.vcf.annotator.model.Settings;

/*
 * Exception performing whole class analysis ignored.
 */
public class SampleAnnotator {
    public static void annotate(Settings settings) {
        Map mapping = MappingReader.readMappingFile((File)settings.getMapping());
        VCFFileReader reader = new VCFFileReader(settings.getInputPath(), false);
        Map vepMapping = SampleAnnotator.getVepMapping((VCFHeader)reader.getHeader());
        Map annotations = TSVReader.readTSV((File)settings.getAnnotationFile(), (String)settings.getKeyColumn());
        VariantContextWriter vcfWriter = new VariantContextWriterBuilder().clearOptions().setOutputFile(settings.getOutputPath()).build();
        VCFHeader header = reader.getHeader();
        HashSet<String> columns = new HashSet<String>();
        columns.addAll(Set.of(settings.getColumns()));
        columns.add("vipGene");
        for (String column : columns) {
            header.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine(column, VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, String.format("Annotation from %s column of %s", column, settings.getAnnotationFile().getName())));
        }
        vcfWriter.writeHeader(header);
        SampleAnnotator.annotateVariant((Settings)settings, (VCFReader)reader, (Map)vepMapping, (Map)mapping, (Map)annotations, (VariantContextWriter)vcfWriter);
        vcfWriter.close();
    }

    private static void annotateVariant(Settings settings, VCFReader reader, Map<String, Integer> vepMapping, Map<String, String> mapping, Map<String, Map<String, String>> annotations, VariantContextWriter vcfWriter) {
        for (VariantContext variantContext : reader) {
            VariantContextBuilder vcBuilder = new VariantContextBuilder(variantContext);
            List csqs = variantContext.getAttributeAsStringList("CSQ", "");
            HashMap genotypeGenes = new HashMap();
            for (String csq : csqs) {
                Integer allele_num = Integer.valueOf(csq.split("\\|")[vepMapping.get("ALLELE_NUM")]);
                String entrez = csq.split("\\|")[vepMapping.get("Gene")];
                for (Genotype genotype : variantContext.getGenotypes()) {
                    HashSet<String> genes = new HashSet<String>();
                    for (Allele allele : genotype.getAlleles()) {
                        if (variantContext.getAlleleIndex(allele) != allele_num.intValue()) continue;
                        if (genotypeGenes.containsKey(genotype)) {
                            genes.addAll((Collection)genotypeGenes.get(genotype));
                        }
                        if (entrez.isEmpty()) continue;
                        genes.add(entrez);
                    }
                    genotypeGenes.put(genotype, genes);
                }
            }
            ArrayList<Genotype> genotypes = new ArrayList<Genotype>();
            for (Genotype genotype : variantContext.getGenotypes()) {
                if (genotypeGenes.containsKey(genotype)) {
                    GenotypeBuilder builder = new GenotypeBuilder(genotype);
                    builder.attribute("vipGene", (Object)String.join((CharSequence)",", (Iterable)genotypeGenes.get(genotype)));
                    for (String entrez : (Set)genotypeGenes.get(genotype)) {
                        String ensembl = mapping.get(entrez);
                        Map<String, String> geneAnnotations = annotations.get(ensembl);
                        if (geneAnnotations == null) continue;
                        for (String column : settings.getColumns()) {
                            builder.attribute(column, (Object)geneAnnotations.get(column));
                        }
                    }
                    genotypes.add(builder.make());
                    continue;
                }
                genotypes.add(genotype);
            }
            vcBuilder.genotypes(genotypes);
            vcfWriter.add(vcBuilder.make());
        }
    }

    private static Map<String, Integer> getVepMapping(VCFHeader header) {
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (VCFInfoHeaderLine line : header.getInfoHeaderLines()) {
            if (!line.getID().equals("CSQ")) continue;
            String desc = line.getDescription();
            int startIdx = desc.indexOf("Format:") + 7;
            String formatPart = desc.substring(startIdx);
            String[] fields = formatPart.split("\\|");
            for (int i = 0; i < fields.length; ++i) {
                indices.put(fields[i], i);
            }
        }
        return indices;
    }
}

