/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.annotator;

import java.util.Locale;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.molgenis.vcf.annotator.AppCommandLineOptions;
import org.molgenis.vcf.annotator.AppCommandLineToSettingsMapper;
import org.molgenis.vcf.annotator.SampleAnnotator;
import org.molgenis.vcf.annotator.model.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
class AppCommandLineRunner
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppCommandLineRunner.class);
    private static final int STATUS_MISC_ERROR = 1;
    private static final int STATUS_COMMAND_LINE_USAGE_ERROR = 64;
    private final AppCommandLineToSettingsMapper appCommandLineToSettingsMapper;
    private final CommandLineParser commandLineParser;

    AppCommandLineRunner(AppCommandLineToSettingsMapper appCommandLineToSettingsMapper) {
        this.appCommandLineToSettingsMapper = Objects.requireNonNull(appCommandLineToSettingsMapper);
        this.commandLineParser = new DefaultParser();
    }

    public void run(String ... args) {
        Locale.setDefault(Locale.Category.FORMAT, Locale.US);
        try {
            Settings settings = this.createSettings(args);
            SampleAnnotator.annotate((Settings)settings);
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    private Settings createSettings(String ... args) {
        CommandLine commandLine = null;
        try {
            commandLine = this.commandLineParser.parse(AppCommandLineOptions.getAppOptions(), args);
        }
        catch (ParseException e) {
            this.logException(e);
            System.exit(64);
        }
        AppCommandLineOptions.validateCommandLine((CommandLine)commandLine);
        return this.appCommandLineToSettingsMapper.map(commandLine, args);
    }

    private void logException(ParseException e) {
        LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(null);
        String cmdLineSyntax = "java -jar sampleAnnotator.jar";
        formatter.printHelp(cmdLineSyntax, AppCommandLineOptions.getAppOptions(), true);
        System.out.println();
    }
}

