/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.annotator;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

/*
 * Exception performing whole class analysis ignored.
 */
class AppCommandLineOptions {
    static final String OPT_INPUT = "i";
    static final String OPT_INPUT_LONG = "input";
    static final String OPT_MAPPING = "m";
    static final String OPT_MAPPING_LONG = "mapping";
    static final String OPT_ANNOTATION = "a";
    static final String OPT_ANNOTATION_LONG = "annotation";
    static final String OPT_COLUMNS = "c";
    static final String OPT_COLUMNS_LONG = "columns";
    static final String OPT_KEY = "k";
    static final String OPT_KEY_LONG = "key";
    static final String OPT_OUTPUT = "o";
    static final String OPT_OUTPUT_LONG = "output";
    static final String OPT_FORCE = "f";
    static final String OPT_FORCE_LONG = "force";
    static final String OPT_PROBANDS = "pb";
    static final String OPT_PROBANDS_LONG = "probands";
    private static final Options APP_OPTIONS;

    private AppCommandLineOptions() {
    }

    static Options getAppOptions() {
        return APP_OPTIONS;
    }

    static void validateCommandLine(CommandLine commandLine) {
        AppCommandLineOptions.validateInput((CommandLine)commandLine);
        AppCommandLineOptions.validateOutput((CommandLine)commandLine);
    }

    private static void validateInput(CommandLine commandLine) {
        Path inputPath = Path.of(commandLine.getOptionValue("i"), new String[0]);
        if (!Files.exists(inputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Input file '%s' does not exist.", inputPath));
        }
        if (Files.isDirectory(inputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Input file '%s' is a directory.", inputPath));
        }
        if (!Files.isReadable(inputPath)) {
            throw new IllegalArgumentException(String.format("Input file '%s' is not readable.", inputPath));
        }
        String inputPathStr = inputPath.toString();
        if (!inputPathStr.endsWith(".vcf") && !inputPathStr.endsWith(".vcf.gz")) {
            throw new IllegalArgumentException(String.format("Input file '%s' is not a .vcf or .vcf.gz file.", inputPathStr));
        }
    }

    private static void validateOutput(CommandLine commandLine) {
        if (!commandLine.hasOption("o")) {
            return;
        }
        Path outputPath = Path.of(commandLine.getOptionValue("o"), new String[0]);
        if (!commandLine.hasOption("f") && Files.exists(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Output file '%s' already exists", outputPath));
        }
    }

    static {
        Options appOptions = new Options();
        appOptions.addOption(Option.builder((String)"i").hasArg(true).required().longOpt("input").desc("VEP* annotated input VCF file.").build());
        appOptions.addOption(Option.builder((String)"o").hasArg(true).longOpt("output").desc("Output VCF file (.vcf or .vcf.gz).").build());
        appOptions.addOption(Option.builder((String)"f").longOpt("force").desc("Override the output file if it already exists.").build());
        appOptions.addOption(Option.builder((String)"c").hasArg(true).longOpt("columns").desc("TODO.").build());
        appOptions.addOption(Option.builder((String)"m").hasArg(true).longOpt("mapping").desc("TODO.").build());
        appOptions.addOption(Option.builder((String)"a").hasArg(true).longOpt("annotation").desc("TODO.").build());
        appOptions.addOption(Option.builder((String)"k").hasArg(true).longOpt("key").desc("TODO.").build());
        appOptions.addOption(Option.builder((String)"pb").hasArg(true).longOpt("probands").desc("Comma-separated list of proband names.").build());
        APP_OPTIONS = appOptions;
    }
}

