/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.visualizer;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.molgenis.vcf.decisiontree.loader.ConfigDecisionTreeLoaderImpl;
import org.molgenis.vcf.decisiontree.loader.ConfigDecisionTreeValidator;
import org.molgenis.vcf.decisiontree.loader.ConfigDecisionTreeValidatorImpl;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiQuery;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigCategoricalNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigDecisionTree;
import org.molgenis.vcf.decisiontree.loader.model.ConfigExistsNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNodeOutcome;
import org.molgenis.vcf.decisiontree.visualizer.TemplateMissingException;
import org.molgenis.vcf.decisiontree.visualizer.model.Edge;
import org.molgenis.vcf.decisiontree.visualizer.model.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Visualizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Visualizer.class);
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String DEFAULT = "default";
    public static final String MISSING = "missing";
    public static final String OPT_INPUT = "i";
    public static final String OPT_INPUT_LONG = "input";
    public static final String OPT_OUTPUT = "o";
    public static final String OPT_OUTPUT_LONG = "output";
    public static final String OPT_MERMAID = "m";
    public static final String OPT_MERMAID_LONG = "mermaid";
    public static final String OPT_FORCE = "f";
    public static final String OPT_FORCE_LONG = "force";
    private static final int STATUS_COMMAND_LINE_USAGE_ERROR = 64;
    public static final String JSON = ".json";
    public static final String HTML = ".html";

    public static void main(String[] args) {
        CommandLine commandLine = Visualizer.getCommandLine((String[])args);
        Path inputPath = Path.of(commandLine.getOptionValue("i"), new String[0]);
        Path outputPath = commandLine.hasOption("o") ? Path.of(commandLine.getOptionValue("o"), new String[0]) : Path.of(commandLine.getOptionValue("i").replace(".json", ".html"), new String[0]);
        String filename = inputPath.getFileName().toString();
        boolean isMermaidEnabled = commandLine.hasOption("m");
        ConfigDecisionTreeValidatorImpl validator = new ConfigDecisionTreeValidatorImpl();
        ConfigDecisionTreeLoaderImpl loader = new ConfigDecisionTreeLoaderImpl((ConfigDecisionTreeValidator)validator);
        ConfigDecisionTree tree = loader.load(inputPath);
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList edges = new ArrayList();
        for (Map.Entry entry : tree.getNodes().entrySet()) {
            nodes.add(new Node((String)entry.getKey(), ((ConfigNode)entry.getValue()).getLabel(), ((ConfigNode)entry.getValue()).getType() == ConfigNode.Type.LEAF));
            ConfigNode node = (ConfigNode)entry.getValue();
            Visualizer.createEdges(edges, entry, (ConfigNode)node);
        }
        Visualizer.visualizeHtml(nodes, edges, (Path)outputPath, (String)filename, (boolean)isMermaidEnabled);
        LOGGER.info("Decision tree visualization written to '{}'", (Object)outputPath);
    }

    private static CommandLine getCommandLine(String[] args) {
        DefaultParser commandLineParser = new DefaultParser();
        CommandLine commandLine = null;
        Options options = new Options();
        options.addOption(Option.builder((String)"i").longOpt("input").desc("Input .json decision tree file.").hasArg().required().build());
        options.addOption(Option.builder((String)"o").longOpt("output").desc("Output .html file.").hasArg().build());
        options.addOption(Option.builder((String)"f").longOpt("force").desc("Overwrite output file.").build());
        options.addOption(Option.builder((String)"m").longOpt("mermaid").desc("Also output mermaid text file.").build());
        try {
            commandLine = commandLineParser.parse(options, args);
        }
        catch (ParseException e) {
            Visualizer.logException((Options)options);
            System.exit(64);
        }
        Visualizer.validateCommandLine((CommandLine)commandLine);
        return commandLine;
    }

    private static void createEdges(List<Edge> edges, Map.Entry<String, ConfigNode> entry, ConfigNode node) {
        if (node.getType() == ConfigNode.Type.BOOL) {
            ConfigBoolNode boolNode = (ConfigBoolNode)node;
            HashMap<String, String> boolOutcomes = new HashMap<String, String>();
            boolOutcomes.put("true", boolNode.getOutcomeTrue().getNextNode());
            boolOutcomes.put("false", boolNode.getOutcomeFalse().getNextNode());
            boolOutcomes.put("missing", boolNode.getOutcomeMissing().getNextNode());
            Visualizer.processOutcomes(edges, entry, boolOutcomes);
        } else if (node.getType() == ConfigNode.Type.EXISTS) {
            ConfigExistsNode boolNode = (ConfigExistsNode)node;
            HashMap<String, String> boolOutcomes = new HashMap<String, String>();
            boolOutcomes.put("true", boolNode.getOutcomeTrue().getNextNode());
            boolOutcomes.put("false", boolNode.getOutcomeFalse().getNextNode());
            Visualizer.processOutcomes(edges, entry, boolOutcomes);
        } else if (node.getType() == ConfigNode.Type.BOOL_MULTI) {
            Map boolOutcomes = Visualizer.getBoolOutcomes((ConfigBoolMultiNode)((ConfigBoolMultiNode)node));
            Visualizer.processOutcomes(edges, entry, (Map)boolOutcomes);
        } else if (node.getType() == ConfigNode.Type.CATEGORICAL) {
            Map categoricalOutcomes = Visualizer.getCategoricalOutcomes((ConfigCategoricalNode)((ConfigCategoricalNode)node));
            Visualizer.processOutcomes(edges, entry, (Map)categoricalOutcomes);
        }
    }

    private static Map<String, String> getBoolOutcomes(ConfigBoolMultiNode node) {
        HashMap<String, String> boolOutcomes = new HashMap<String, String>();
        for (ConfigBoolMultiQuery configBoolMultiQuery : node.getOutcomes()) {
            boolOutcomes.put(configBoolMultiQuery.getDescription(), configBoolMultiQuery.getOutcomeTrue().getNextNode());
        }
        boolOutcomes.put("default", node.getOutcomeDefault().getNextNode());
        boolOutcomes.put("missing", node.getOutcomeMissing().getNextNode());
        return boolOutcomes;
    }

    private static Map<String, String> getCategoricalOutcomes(ConfigCategoricalNode node) {
        HashMap<String, String> categoricalOutcomes = new HashMap<String, String>();
        if (node.getOutcomeDefault() != null) {
            categoricalOutcomes.put("default", node.getOutcomeDefault().getNextNode());
        }
        for (Map.Entry configEntry : node.getOutcomeMap().entrySet()) {
            categoricalOutcomes.put((String)configEntry.getKey(), ((ConfigNodeOutcome)configEntry.getValue()).getNextNode());
        }
        return categoricalOutcomes;
    }

    private static void validateCommandLine(CommandLine commandLine) {
        Visualizer.validateInput((CommandLine)commandLine);
        Visualizer.validateOutput((CommandLine)commandLine);
    }

    private static void validateInput(CommandLine commandLine) {
        Path inputPath = Path.of(commandLine.getOptionValue("i"), new String[0]);
        if (!Files.exists(inputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Input file '%s' does not exist.", inputPath));
        }
        if (Files.isDirectory(inputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Input file '%s' is a directory.", inputPath));
        }
        if (!Files.isReadable(inputPath)) {
            throw new IllegalArgumentException(String.format("Input file '%s' is not readable.", inputPath));
        }
        String inputPathStr = inputPath.toString();
        if (!inputPathStr.endsWith(".json")) {
            throw new IllegalArgumentException(String.format("Input file '%s' is not a .json file.", inputPathStr));
        }
    }

    private static void validateOutput(CommandLine commandLine) {
        Path outputPath;
        String outputPathStr = commandLine.getOptionValue("o");
        if (commandLine.hasOption("o") && !outputPathStr.endsWith(".html")) {
            throw new IllegalArgumentException(String.format("Output file '%s' is not a .html file.", outputPathStr));
        }
        Path path = outputPath = commandLine.hasOption("o") ? Path.of(commandLine.getOptionValue("o"), new String[0]) : Path.of(commandLine.getOptionValue("i").replace(".json", ".html"), new String[0]);
        if (!commandLine.hasOption("f") && Files.exists(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Output file '%s' already exists", outputPath));
        }
    }

    private static void visualizeHtml(List<Node> nodes, List<Edge> edges, Path outputPath, String title, boolean isMermaidEnabled) {
        StringBuilder mmdContent = new StringBuilder();
        mmdContent.append("flowchart TD\n");
        for (Node node : nodes) {
            mmdContent.append(Visualizer.nodeToMmd((Node)node));
            mmdContent.append("\n");
            if (!node.isLeaf()) continue;
            mmdContent.append(String.format("style %s_ fill:#00ff00%n", node.getId()));
        }
        for (Edge edge : edges) {
            mmdContent.append(Visualizer.edgeToMmd((Edge)edge));
            mmdContent.append("\n");
        }
        try {
            Path templatePath = Paths.get(Objects.requireNonNull(Visualizer.class.getResource("/template-mmd.html")).toURI());
            String template = Files.readString(templatePath);
            String output = template.replace("MERMAID_PLACEHOLDER", mmdContent.toString()).replace("TITLE_PLACEHOLDER", title);
            Files.writeString(outputPath, (CharSequence)output, new OpenOption[0]);
            if (isMermaidEnabled) {
                Files.writeString(Path.of(outputPath.toString().replace(".html", ".mmd"), new String[0]), (CharSequence)mmdContent.toString(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (URISyntaxException e) {
            throw new TemplateMissingException();
        }
    }

    private static String edgeToMmd(Edge edge) {
        String label = edge.getLabel() != null ? edge.getLabel() : "Add description to visualize a label.";
        return String.format("%s_ -->|\"%s\"| %s_", edge.getNode1(), label, edge.getNode2());
    }

    private static String nodeToMmd(Node node) {
        return String.format("%s_(\"%s\")", node.getId(), node.getLabel());
    }

    private static void processOutcomes(List<Edge> edges, Map.Entry<String, ConfigNode> entry, Map<String, String> outcomes) {
        for (Map.Entry<String, String> outcome : outcomes.entrySet()) {
            edges.add(new Edge(entry.getKey(), outcome.getValue(), outcome.getKey()));
        }
    }

    private static void logException(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(null);
        String cmdLineSyntax = "java -jar vcf-decision-tree-visualizer.jar";
        formatter.printHelp(cmdLineSyntax, options, true);
    }
}

