/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.utils;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.molgenis.vcf.decisiontree.filter.UnsupportedFieldException;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.utils.TypeConversionException;
import org.molgenis.vcf.decisiontree.utils.VcfUtils;
import org.molgenis.vcf.utils.UnexpectedEnumException;
import org.molgenis.vcf.utils.metadata.ValueType;
import org.springframework.lang.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class VcfUtils {
    public static final String FIELD_TOKEN_SEPARATOR = "/";

    private VcfUtils() {
    }

    public static Integer getInfoAsInteger(VariantContext variantContext, Field field) {
        Object value = variantContext.getAttribute(field.getId());
        String missingValue = VcfUtils.getMissingValue((Field)field);
        return VcfUtils.getVcfValueAsInteger((Object)value, (String)missingValue);
    }

    public static List<Integer> getInfoAsIntegerList(VariantContext variantContext, Field field) {
        List<Integer> integerValues;
        String missingValue = VcfUtils.getMissingValue((Field)field);
        Object value = variantContext.getAttribute(field.getId());
        if (value == null) {
            integerValues = List.of();
        } else if (value instanceof List) {
            List objectValues = (List)value;
            int size = objectValues.size();
            if (size == 0) {
                integerValues = Collections.emptyList();
            } else if (size == 1) {
                integerValues = Collections.singletonList(VcfUtils.getVcfValueAsInteger(objectValues.get(0), (String)missingValue));
            } else {
                integerValues = new ArrayList<Integer>(objectValues.size());
                for (Object objValue : objectValues) {
                    integerValues.add(VcfUtils.getVcfValueAsInteger(objValue, (String)missingValue));
                }
            }
        } else if (value instanceof String) {
            String stringValue = (String)value;
            integerValues = Collections.singletonList(VcfUtils.getInfoStringValueAsInteger((String)stringValue, (String)missingValue));
        } else {
            throw new TypeConversionException(value, Integer.class);
        }
        return integerValues;
    }

    @Nullable
    private static Integer getVcfValueAsInteger(@Nullable Object objValue, String missingValue) {
        Integer intValue;
        if (objValue == null) {
            intValue = null;
        } else if (objValue instanceof Integer) {
            Integer integer;
            intValue = integer = (Integer)objValue;
        } else if (objValue instanceof String) {
            String stringValue = (String)objValue;
            intValue = VcfUtils.getInfoStringValueAsInteger((String)stringValue, (String)missingValue);
        } else {
            throw new TypeConversionException(objValue, Integer.class);
        }
        return intValue;
    }

    @Nullable
    private static Integer getInfoStringValueAsInteger(String infoStrValue, String missingValue) {
        Integer intValue = infoStrValue.equals(missingValue) ? null : Integer.valueOf(infoStrValue);
        return intValue;
    }

    public static Double getInfoAsDouble(VariantContext variantContext, Field field) {
        Object value = variantContext.getAttribute(field.getId());
        String missingValue = VcfUtils.getMissingValue((Field)field);
        return VcfUtils.getVcfValueAsDouble((Object)value, (String)missingValue);
    }

    public static List<Double> getInfoAsDoubleList(VariantContext variantContext, Field field) {
        List<Double> doubleValues;
        String missingValue = VcfUtils.getMissingValue((Field)field);
        Object value = variantContext.getAttribute(field.getId());
        if (value == null) {
            doubleValues = List.of();
        } else if (value instanceof List) {
            List objectValues = (List)value;
            int size = objectValues.size();
            if (size == 0) {
                doubleValues = Collections.emptyList();
            } else if (size == 1) {
                doubleValues = Collections.singletonList(VcfUtils.getVcfValueAsDouble(objectValues.get(0), (String)missingValue));
            } else {
                doubleValues = new ArrayList<Double>(objectValues.size());
                for (Object objValue : objectValues) {
                    doubleValues.add(VcfUtils.getVcfValueAsDouble(objValue, (String)missingValue));
                }
            }
        } else if (value instanceof String) {
            String string = (String)value;
            doubleValues = Collections.singletonList(VcfUtils.getInfoStringValueAsDouble((String)string, (String)missingValue));
        } else {
            throw new TypeConversionException(value, Double.class);
        }
        return doubleValues;
    }

    private static String getMissingValue(Field field) {
        return field.getFieldType() == FieldType.FORMAT ? "" : ".";
    }

    @Nullable
    private static Double getVcfValueAsDouble(@Nullable Object objValue, String missingValue) {
        Double doubleValue;
        if (objValue == null) {
            doubleValue = null;
        } else if (objValue instanceof Double) {
            Double doubleVal;
            doubleValue = doubleVal = (Double)objValue;
        } else if (objValue instanceof String) {
            String string = (String)objValue;
            doubleValue = VcfUtils.getInfoStringValueAsDouble((String)string, (String)missingValue);
        } else {
            throw new TypeConversionException(objValue, Double.class);
        }
        return doubleValue;
    }

    @Nullable
    private static Double getInfoStringValueAsDouble(String infoStrValue, String missingValue) {
        Double doubleValue = infoStrValue.equals(missingValue) ? null : Double.valueOf(infoStrValue);
        return doubleValue;
    }

    public static String getInfoAsString(VariantContext variantContext, Field field) {
        Object value = variantContext.getAttribute(field.getId());
        String missingValue = VcfUtils.getMissingValue((Field)field);
        return VcfUtils.getVcfValueAsString((Object)value, (String)missingValue);
    }

    public static List<String> getInfoAsStringList(VariantContext variantContext, Field field) {
        String id = field.getId();
        String missingValue = VcfUtils.getMissingValue((Field)field);
        List strValues = VcfUtils.getInfoAsStringList((VariantContext)variantContext, (String)id, (String)missingValue);
        return strValues;
    }

    public static List<String> getInfoAsStringList(VariantContext variantContext, String id, String missingValue) {
        List<String> strValues;
        Object value = variantContext.getAttribute(id);
        if (value == null) {
            strValues = List.of();
        } else if (value instanceof List) {
            List objectValues = (List)value;
            int size = objectValues.size();
            if (size == 0) {
                strValues = Collections.emptyList();
            } else if (size == 1) {
                strValues = Collections.singletonList(VcfUtils.getVcfValueAsString(objectValues.get(0), (String)missingValue));
            } else {
                strValues = new ArrayList<String>(objectValues.size());
                for (Object objValue : objectValues) {
                    strValues.add(VcfUtils.getVcfValueAsString(objValue, (String)missingValue));
                }
            }
        } else if (value instanceof String) {
            String string = (String)value;
            strValues = Collections.singletonList(VcfUtils.getInfoStringValueAsString((String)string, (String)missingValue));
        } else {
            throw new TypeConversionException(value, String.class);
        }
        return strValues;
    }

    @Nullable
    private static String getVcfValueAsString(@Nullable Object objValue, String missingValue) {
        String strValue;
        if (objValue == null) {
            strValue = null;
        } else if (objValue instanceof String) {
            String string = (String)objValue;
            strValue = VcfUtils.getInfoStringValueAsString((String)string, (String)missingValue);
        } else {
            throw new TypeConversionException(objValue, String.class);
        }
        return strValue;
    }

    @Nullable
    private static String getInfoStringValueAsString(String infoStrValue, String missingValue) {
        String stringValue = infoStrValue.equals(missingValue) ? null : infoStrValue;
        return stringValue;
    }

    public static boolean getInfoAsBoolean(VariantContext variantContext, Field field) {
        Object objValue = variantContext.getAttribute(field.getId());
        return VcfUtils.getVcfValueAsBoolean((Object)objValue);
    }

    private static boolean getVcfValueAsBoolean(Object objValue) {
        boolean bool;
        if (objValue == null) {
            bool = false;
        } else if (objValue instanceof Boolean) {
            Boolean boolVal = (Boolean)objValue;
            bool = boolVal;
        } else {
            throw new TypeConversionException(objValue, Boolean.class);
        }
        return bool;
    }

    public static Object getTypedVcfValue(Field field, String stringValue, String separator) {
        List<Object> value;
        if (separator == null) {
            value = VcfUtils.getTypedVcfValue((Field)field, (String)stringValue);
        } else {
            List<String> values = Arrays.asList(stringValue.split(separator));
            value = values.stream().map(singleValue -> VcfUtils.getTypedVcfValue((Field)field, (String)singleValue)).toList();
        }
        return value;
    }

    public static Object getTypedVcfValue(Field field, String stringValue) {
        ValueType valueType = field.getValueType();
        String missingValue = VcfUtils.getMissingValue((Field)field);
        return switch (1.$SwitchMap$org$molgenis$vcf$utils$metadata$ValueType[valueType.ordinal()]) {
            case 1 -> VcfUtils.getVcfValueAsInteger((Object)stringValue, (String)missingValue);
            case 2 -> VcfUtils.getVcfValueAsBoolean((Object)stringValue);
            case 3 -> VcfUtils.getVcfValueAsDouble((Object)stringValue, (String)missingValue);
            case 4, 5, 6 -> VcfUtils.getVcfValueAsString((Object)stringValue, (String)missingValue);
            default -> throw new UnexpectedEnumException((Enum)valueType);
        };
    }

    public static Object getTypedVcfListValue(Field field, String stringValue) {
        String[] stringValues = stringValue.split(",");
        ArrayList<Object> values = new ArrayList<Object>();
        for (String value : stringValues) {
            values.add(VcfUtils.getTypedVcfValue((Field)field, (String)value));
        }
        return values;
    }

    public static FieldType toFieldType(List<String> fields) {
        String rootField;
        return switch (rootField = fields.get(0)) {
            case "#CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER" -> FieldType.COMMON;
            case "INFO" -> fields.size() > 2 ? FieldType.INFO_VEP : FieldType.INFO;
            case "FORMAT" -> fields.size() > 2 ? FieldType.GENOTYPE : FieldType.FORMAT;
            case "SAMPLE" -> FieldType.SAMPLE;
            default -> throw new UnsupportedFieldException(rootField);
        };
    }
}

