/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner.info;

import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldImpl;
import org.molgenis.vcf.decisiontree.filter.model.NestedField;
import org.molgenis.vcf.decisiontree.runner.VepHelper;
import org.molgenis.vcf.decisiontree.runner.info.MissingVepMetaException;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.molgenis.vcf.decisiontree.runner.info.NotParentFieldException;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataMapper;
import org.molgenis.vcf.utils.metadata.FieldIdentifier;
import org.molgenis.vcf.utils.metadata.FieldMetadataService;
import org.molgenis.vcf.utils.metadata.FieldType;
import org.molgenis.vcf.utils.metadata.NestedAttributes;
import org.molgenis.vcf.utils.metadata.ValueCount;
import org.molgenis.vcf.utils.metadata.ValueType;
import org.molgenis.vcf.utils.model.metadata.FieldMetadata;
import org.molgenis.vcf.utils.model.metadata.FieldMetadatas;
import org.molgenis.vcf.utils.model.metadata.NestedFieldMetadata;

public class VepMetadataMapperImpl
implements VepMetadataMapper {
    public static final String ALLELE_NUM = "ALLELE_NUM";
    public static final String PICK = "PICK";
    private final FieldMetadataService fieldMetadataService;

    public VepMetadataMapperImpl(FieldMetadataService fieldMetadataService) {
        this.fieldMetadataService = Objects.requireNonNull(fieldMetadataService);
    }

    public boolean canMap(VCFInfoHeaderLine vcfInfoHeaderLine) {
        return VepHelper.canMap((VCFInfoHeaderLine)vcfInfoHeaderLine);
    }

    public NestedHeaderLine map(String csqId, VCFHeader vcfHeader) {
        VCFInfoHeaderLine vcfInfoHeaderLine = vcfHeader.getInfoHeaderLine(csqId);
        FieldImpl vepField = FieldImpl.builder().id(vcfInfoHeaderLine.getID()).fieldType(org.molgenis.vcf.decisiontree.filter.model.FieldType.INFO).valueType(ValueType.STRING).valueCount(ValueCount.builder().type(ValueCount.Type.VARIABLE).build()).separator(Character.valueOf('|')).build();
        FieldMetadatas fieldMetadatas = this.fieldMetadataService.load(vcfHeader, Map.of(FieldIdentifier.builder().type(FieldType.INFO).name(csqId).build(), NestedAttributes.builder().prefix("Consequence annotations from Ensembl VEP. Format: ").seperator("|").build()));
        HashMap<String, NestedField> nestedFields = new HashMap<String, NestedField>();
        FieldMetadata csqField = (FieldMetadata)fieldMetadatas.getInfo().get(csqId);
        if (csqField == null) {
            throw new MissingVepMetaException();
        }
        Map nestedFieldsMeta = csqField.getNestedFields();
        if (nestedFieldsMeta == null) {
            throw new NotParentFieldException(csqId);
        }
        for (Map.Entry entry : nestedFieldsMeta.entrySet()) {
            nestedFields.put((String)entry.getKey(), this.mapNestedFieldMetadata((String)entry.getKey(), (NestedFieldMetadata)entry.getValue(), (Field)vepField));
        }
        return NestedHeaderLine.builder().parentField((Field)vepField).nestedFields(nestedFields).build();
    }

    private NestedField mapNestedFieldMetadata(String id, NestedFieldMetadata nestedMeta, Field parent) {
        return new NestedField(id, org.molgenis.vcf.decisiontree.filter.model.FieldType.INFO_VEP, nestedMeta.getType(), ValueCount.builder().count(nestedMeta.getNumberCount()).type(nestedMeta.getNumberType()).build(), nestedMeta.getNumberCount(), nestedMeta.getSeparator(), nestedMeta.getIndex(), parent);
    }
}

