/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner.info;

import htsjdk.variant.vcf.VCFHeader;
import java.util.HashMap;
import java.util.Map;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldImpl;
import org.molgenis.vcf.utils.metadata.FieldIdentifier;
import org.molgenis.vcf.utils.metadata.FieldMetadataServiceImpl;
import org.molgenis.vcf.utils.metadata.FieldType;
import org.molgenis.vcf.utils.metadata.NestedAttributes;
import org.molgenis.vcf.utils.metadata.ValueCount;
import org.molgenis.vcf.utils.metadata.ValueType;
import org.molgenis.vcf.utils.model.metadata.FieldMetadata;
import org.molgenis.vcf.utils.model.metadata.FieldMetadatas;

public class FormatMetadataMapper {
    private final Settings settings;

    public FormatMetadataMapper(Settings settings) {
        this.settings = settings;
    }

    public Map<String, Field> map(VCFHeader vcfHeader) {
        FieldMetadataServiceImpl fieldMetadataService = new FieldMetadataServiceImpl(this.settings.getMetadataPath().toFile());
        FieldImpl vepField = FieldImpl.builder().id("CSQ").fieldType(org.molgenis.vcf.decisiontree.filter.model.FieldType.INFO).valueType(ValueType.STRING).valueCount(ValueCount.builder().type(ValueCount.Type.VARIABLE).build()).separator(Character.valueOf('|')).build();
        FieldMetadatas fieldMetadatas = fieldMetadataService.load(vcfHeader, Map.of(FieldIdentifier.builder().type(FieldType.INFO).name("CSQ").build(), NestedAttributes.builder().prefix("Consequence annotations from Ensembl VEP. Format: ").seperator("|").build()));
        Map formatMeta = fieldMetadatas.getFormat();
        HashMap<String, Field> mappedFormatMeta = new HashMap<String, Field>();
        formatMeta.entrySet().forEach(entry -> mappedFormatMeta.put((String)entry.getKey(), this.mapFieldMetadata((String)entry.getKey(), (FieldMetadata)entry.getValue())));
        return mappedFormatMeta;
    }

    private Field mapFieldMetadata(String id, FieldMetadata newMeta) {
        return new FieldImpl(id, org.molgenis.vcf.decisiontree.filter.model.FieldType.FORMAT, newMeta.getType(), ValueCount.builder().count(newMeta.getNumberCount()).type(newMeta.getNumberType()).build(), newMeta.getNumberCount(), newMeta.getSeparator());
    }
}

