/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.util.Strings;
import org.molgenis.vcf.decisiontree.filter.UnknownFieldException;
import org.molgenis.vcf.decisiontree.filter.VcfRecord;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.NestedField;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;

/*
 * Exception performing whole class analysis ignored.
 */
public class VepHelper {
    public static final String INFO_DESCRIPTION_PREFIX = "Consequence annotations from Ensembl VEP. Format: ";

    public Map<Integer, List<VcfRecord>> getRecordPerConsequence(VcfRecord vcfRecord, NestedHeaderLine nestedHeaderLine) {
        List consequences = vcfRecord.getVepValues(nestedHeaderLine.getParentField());
        HashMap<Integer, List<VcfRecord>> records = new HashMap<Integer, List<VcfRecord>>();
        for (String consequence : consequences) {
            Field field = nestedHeaderLine.getField("ALLELE_NUM");
            if (!(field instanceof NestedField)) {
                throw new UnknownFieldException("ALLELE_NUM", FieldType.INFO_VEP);
            }
            NestedField alleleField = (NestedField)field;
            int alleleNumIndex = alleleField.getIndex();
            int index = Integer.parseInt(consequence.split("\\|")[alleleNumIndex]);
            List<Object> singleCsqRecord = records.containsKey(index) ? (List)records.get(index) : new ArrayList<VcfRecord>();
            singleCsqRecord.add(vcfRecord.getFilteredCopy(consequence, nestedHeaderLine.getParentField()));
            records.put(index, singleCsqRecord);
        }
        return records;
    }

    public VcfRecord createEmptyCsqRecord(VcfRecord vcfRecord, Integer alleleIndex, NestedHeaderLine nestedHeaderLine) {
        Map fields = nestedHeaderLine.getNestedFields();
        ArrayList<String> values = new ArrayList<String>();
        for (int index = 0; index < fields.size(); ++index) {
            values.add("");
        }
        values.set(((NestedField)fields.get("ALLELE_NUM")).getIndex(), alleleIndex.toString());
        NestedField pick = (NestedField)fields.get("PICK");
        if (pick != null) {
            values.set(pick.getIndex(), "1");
        }
        VariantContext variantContext = vcfRecord.getVariantContext();
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder(variantContext);
        variantContextBuilder.attribute(nestedHeaderLine.getParentField().getId(), Collections.singletonList(Strings.join(values, (char)'|')));
        return new VcfRecord(variantContextBuilder.make());
    }

    public static String getVepId(VCFHeader vcfHeader) {
        for (VCFInfoHeaderLine vcfInfoHeaderLine : vcfHeader.getInfoHeaderLines()) {
            if (!VepHelper.canMap((VCFInfoHeaderLine)vcfInfoHeaderLine)) continue;
            return vcfInfoHeaderLine.getID();
        }
        return null;
    }

    public static boolean canMap(VCFInfoHeaderLine vcfInfoHeaderLine) {
        String description = vcfInfoHeaderLine.getDescription();
        return description.startsWith("Consequence annotations from Ensembl VEP. Format: ");
    }
}

