/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import htsjdk.variant.vcf.VCFFileReader;
import java.nio.file.Path;
import java.util.Objects;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.filter.VcfReader;
import org.molgenis.vcf.decisiontree.runner.VcfReaderFactory;
import org.molgenis.vcf.decisiontree.runner.info.FormatMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.GenotypeMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataMapperFactory;
import org.springframework.stereotype.Component;

@Component
class VcfReaderFactoryImpl
implements VcfReaderFactory {
    private final GenotypeMetadataMapper genotypeMetadataMapper;
    private final VepMetadataMapperFactory vepMetadataMapperFactory;

    VcfReaderFactoryImpl(VepMetadataMapperFactory vepMetadataMapperFactory, GenotypeMetadataMapper genotypeMetadataMapper) {
        this.vepMetadataMapperFactory = Objects.requireNonNull(vepMetadataMapperFactory);
        this.genotypeMetadataMapper = Objects.requireNonNull(genotypeMetadataMapper);
    }

    public VcfReader create(Settings settings) {
        VepMetadataMapper vepMetadataMapper = this.vepMetadataMapperFactory.create(settings);
        FormatMetadataMapper formatMetadataMapper = new FormatMetadataMapper(settings);
        Path inputVcfPath = settings.getInputVcfPath();
        boolean strict = settings.isStrict();
        return new VcfReader(new VCFFileReader(inputVcfPath.toFile(), false), vepMetadataMapper, this.genotypeMetadataMapper, formatMetadataMapper, strict);
    }
}

