/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.LinkedHashSet;
import java.util.Set;
import org.molgenis.vcf.decisiontree.AppSettings;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.WriterSettings;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.model.Mode;
import org.molgenis.vcf.decisiontree.runner.info.MissingVepException;
import org.molgenis.vcf.utils.utils.HeaderUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class HeaderAnnotator {
    private static final String HEADER_VIP_VERSION = "VIP_treeVersion";
    private static final String HEADER_VIP_ARGS = "VIP_treeCommand";
    static final String INFO_CLASS_DESC = "VIP decision tree classification";
    public static final String INFO_PATH_DESC = "VIP decision tree path (ampersand separated)";
    public static final String INFO_LABELS_DESC = "VIP decision tree labels (ampersand separated)";
    public static final String INFO_CLASS_ID = "VIPC";
    public static final String INFO_PATH_ID = "VIPP";
    public static final String INFO_LABELS_ID = "VIPL";
    public static final String VIPC_S_DESC = "VIP decision tree classification.";
    public static final String VIPC_S_INFO = "VIP decision tree classification (samples).";
    public static final String VIPP_S_DESC = "VIP decision tree path.";
    public static final String VIPL_S_DESC = "VIP decision tree labels.";

    private HeaderAnnotator() {
    }

    static VCFHeader annotateHeader(VcfMetadata vcfMetadata, Settings settings) {
        AppSettings appSettings = settings.getAppSettings();
        WriterSettings writerSettings = settings.getWriterSettings();
        VCFHeader vcfHeader = new VCFHeader(vcfMetadata.unwrap());
        vcfHeader.addMetaDataLine(new VCFHeaderLine("VIP_treeVersion", appSettings.getVersion()));
        vcfHeader.addMetaDataLine(new VCFHeaderLine("VIP_treeCommand", String.join((CharSequence)" ", appSettings.getArgs())));
        if (settings.getMode() == Mode.VARIANT) {
            VCFHeaderLine vepHeaderLine = HeaderAnnotator.createNewVepHeaderLine((WriterSettings)writerSettings, (VcfMetadata)vcfMetadata);
            vcfHeader = HeaderAnnotator.addVariantHeaders((VcfMetadata)vcfMetadata, (WriterSettings)writerSettings, (VCFHeader)vcfHeader, (VCFHeaderLine)vepHeaderLine);
        } else {
            vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine("VIPC_S", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "VIP decision tree classification (samples)."));
            vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("VIPC_S", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "VIP decision tree classification."));
            if (writerSettings.isWritePath()) {
                vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("VIPP_S", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "VIP decision tree path."));
            }
            if (writerSettings.isWriteLabels()) {
                vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("VIPL_S", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "VIP decision tree labels."));
            }
        }
        return vcfHeader;
    }

    private static VCFHeader addVariantHeaders(VcfMetadata vcfMetadata, WriterSettings writerSettings, VCFHeader vcfHeader, VCFHeaderLine vepHeaderLine) {
        Set infoHeaderLines = HeaderUtils.fixVcfInfoHeaderLines((VCFHeader)vcfHeader);
        for (VCFInfoHeaderLine infoHeaderLine : infoHeaderLines) {
            if (!infoHeaderLine.getID().equals(vcfMetadata.getVepHeaderLine().getParentField().getId())) continue;
            infoHeaderLines.remove(infoHeaderLine);
            break;
        }
        LinkedHashSet<VCFHeaderLine> additionalInfoLines = new LinkedHashSet<VCFHeaderLine>();
        additionalInfoLines.add(new VCFHeaderLine("VIPC", "VIP decision tree classification"));
        if (writerSettings.isWritePath()) {
            additionalInfoLines.add(new VCFHeaderLine("VIPP", "VIP decision tree path (ampersand separated)"));
        }
        if (writerSettings.isWriteLabels()) {
            additionalInfoLines.add(new VCFHeaderLine("VIPL", "VIP decision tree labels (ampersand separated)"));
        }
        LinkedHashSet<VCFHeaderLine> headerLines = new LinkedHashSet<VCFHeaderLine>();
        headerLines.add(vepHeaderLine);
        headerLines.addAll(HeaderUtils.fixVcfFormatHeaderLines((VCFHeader)vcfHeader));
        headerLines.addAll(HeaderUtils.fixVcfFilterHeaderLines((VCFHeader)vcfHeader));
        headerLines.addAll(vcfHeader.getOtherHeaderLines());
        headerLines.addAll(vcfHeader.getContigLines());
        headerLines.addAll(infoHeaderLines);
        headerLines.addAll(additionalInfoLines);
        vcfHeader = new VCFHeader(headerLines, vcfHeader.getGenotypeSamples());
        return vcfHeader;
    }

    private static VCFHeaderLine createNewVepHeaderLine(WriterSettings writerSettings, VcfMetadata vcfMetadata) {
        VCFInfoHeaderLine vepHeader = null;
        for (VCFInfoHeaderLine infoHeaderLine : vcfMetadata.unwrap().getInfoHeaderLines()) {
            if (!infoHeaderLine.getID().equals(vcfMetadata.getVepHeaderLine().getParentField().getId())) continue;
            vepHeader = infoHeaderLine;
            break;
        }
        if (vepHeader == null) {
            throw new MissingVepException();
        }
        StringBuilder vepDescriptionBuilder = new StringBuilder(vepHeader.getDescription());
        vepDescriptionBuilder.append("|");
        vepDescriptionBuilder.append("VIPC");
        if (writerSettings.isWritePath()) {
            vepDescriptionBuilder.append("|");
            vepDescriptionBuilder.append("VIPP");
        }
        if (writerSettings.isWriteLabels()) {
            vepDescriptionBuilder.append("|");
            vepDescriptionBuilder.append("VIPL");
        }
        return new VCFInfoHeaderLine(vepHeader.getID(), vepHeader.getCountType(), vepHeader.getType(), vepDescriptionBuilder.toString(), vepHeader.getSource(), vepHeader.getVersion());
    }
}

